<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'UrbanGoListingCategoryList' ) ) {
	class UrbanGoListingCategoryList extends UrbanGoEdgeClassWidget {
		
		public function __construct() {
			parent::__construct(
				'edgtf_category_list',
				esc_html__( 'UrbanGo Listing Category List', 'urbango-listing' ),
				array( 'description' => esc_html__( 'Display a list of categories for listing items', 'urbango-listing' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'  => 'textfield',
					'name'  => 'widget_bottom_margin',
					'title' => esc_html__( 'Widget Bottom Margin (px)', 'urbango-listing' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'widget_title',
					'title' => esc_html__( 'Widget Title', 'urbango-listing' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'widget_title_bottom_margin',
					'title' => esc_html__( 'Widget Title Bottom Margin (px)', 'urbango-listing' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'number_of_items',
					'title' => esc_html__( 'Number Of Categories', 'urbango-listing' )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'category',
					'title'   => esc_html__( 'Category', 'urbango-listing' ),
					'options' => urbango_listing_get_cpt_taxonomy_items( 'category' )
				),
				array(
					'type'        => 'textfield',
					'name'        => 'category_slugs',
					'title'       => esc_html__( 'Category Slugs', 'urbango-listing' ),
					'description' => esc_html__( 'Enter the category slugs you want to display, separated by commas (leave empty for showing all categories)', 'urbango-listing' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			if ( ! is_array( $instance ) ) {
				$instance = array();
			}
			
			$instance['number_of_columns']   = 'one';
			$instance['space_between_items'] = 'tiny';
			$instance['title_tag']           = 'p';
			$instance['enable_excerpt']      = 'no';
			$instance['enable_items_count']  = 'no';
			
			// Filter out all empty params
			$instance         = array_filter( $instance, function ( $array_value ) {
				return trim( $array_value ) != '';
			} );
			
			$params = '';
			//generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}
			
			$widget_styles = array();
			if ( isset( $instance['widget_bottom_margin'] ) && $instance['widget_bottom_margin'] !== '' ) {
				$widget_styles[] = 'margin-bottom: ' . urbango_edge_filter_px( $instance['widget_bottom_margin'] ) . 'px';
			}
			
			$widget_title_styles = array();
			if ( isset( $instance['widget_title_bottom_margin'] ) && $instance['widget_title_bottom_margin'] !== '' ) {
				$widget_title_styles[] = 'margin-bottom: ' . urbango_edge_filter_px( $instance['widget_title_bottom_margin'] ) . 'px';
			}
			
			
			
			echo '<div class="widget edgtf-category-list-widget" ' . urbango_edge_get_inline_style( $widget_styles ) . '>';
			if ( ! empty( $instance['widget_title'] ) ) {
				if ( ! empty( $widget_title_styles ) ) {
					$args['before_title'] = urbango_edge_widget_modified_before_title( $args['before_title'], $widget_title_styles ) ;
				}
				
				echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['widget_title'] ) . wp_kses_post( $args['after_title'] );
			}
			
			echo do_shortcode( "[edgtf_category_list $params]" ); // XSS OK
			echo '</div>';
		}
	}
}
