<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! empty( $terms_meta ) ) {
	foreach ( $terms_meta as $key => $value ) {
		if ( ! empty( $value ) ) {
			foreach ( $value as $term_meta ) {
				if ( ! empty( $term_meta ) ) {
					$term = isset( $is_term_meta ) && $is_term_meta ? get_term( $term_meta, 'listing-' . $taxonomy ) : $term_meta;
					
					if ( is_object( $term ) ) {
						$term_id = $term->term_id;
						?>
						<div class="edgtf-ls-combined-item">
							<a itemprop="url" class="edgtf-ls-<?php echo esc_attr( $taxonomy ); ?> edgtf-ls-<?php echo esc_attr( $key ); ?>-item" href="<?php echo esc_url( get_term_link( $term_id ) ); ?>">
								<?php if ( $key === 'included' ) { ?>
									<i class="edgtf-ls-combined-icon far fa-check-square"></i>
								<?php } else if ( $key === 'excluded' ) { ?>
									<i class="edgtf-ls-combined-icon far fa-square"></i>
								<?php } ?>
								<span class="edgtf-ls-<?php echo esc_attr( $taxonomy ); ?>-label"><?php echo esc_html( $term->name ); ?></span>
							</a>
						</div>
					<?php }
				}
			}
		}
	}
}
?>