<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$price_range_meta = get_post_meta( get_the_ID(), 'edgtf_listing_single_price_range_meta', true );

if ( ! empty( $price_range_meta ) ) { ?>
	<div class="edgtf-ls-price-range">
		<span class="edgtf-ls-price-range-title"><?php esc_html_e( 'Prices', 'urbango-listing' ); ?></span>
		<span class="edgtf-ls-price-range-icons">
			<?php for ( $i = 1; $i <= 5; $i ++ ) {
				$item_class = $i <= $price_range_meta ? 'edgtf-active' : '';
				?>
				<i class="edgtf-ls-price-range-icon fas fa-dollar-sign <?php echo esc_attr( $item_class ); ?>"></i>
			<?php } ?>
		</span>
	</div>
<?php } ?>