<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$open_table_id = get_post_meta( get_the_ID(), 'edgtf_listing_single_open_table_id_meta', true );

if ( urbango_listing_check_is_listing_open_table_allowed() && ! empty( $open_table_id ) ) { ?>
	<div class="edgtf-ls-open-table">
		<?php urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/parts-title', '', array( 'title' => esc_attr__( 'Book a table', 'urbango-listing' ) ) ); ?>
		
		<form action="http://www.opentable.com/restaurant-search.aspx" target="_blank">
			<select name="partySize">
				<?php foreach ( urbango_listing_get_people_range() as $key => $value ) { ?>
					<option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $value ); ?></option>
				<?php } ?>
			</select>
			
			<input type="date" name="startDate" value="<?php echo date( 'Y-m-d' ); ?>"/>
			
			<select name="ResTime">
				<?php foreach ( urbango_listing_get_hours_range() as $key => $value ) { ?>
					<option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $value ); ?></option>
				<?php } ?>
			</select>
			
			<?php echo urbango_edge_execute_shortcode( 'edgtf_button', array(
				'html_type' => 'button',
				'type'      => 'outline',
				'size'      => 'huge',
				'text'      => esc_html__( 'Book a Table', 'urbango-listing' ),
			) ); ?>
			
			<span class="edgtf-ls-ot-copyright"><?php esc_html_e( 'Powered by OpenTable', 'urbango-listing' ); ?></span>
			
			<input type="hidden" name="RestaurantID" class="RestaurantID" value="<?php echo esc_attr( $open_table_id ); ?>">
			<input type="hidden" name="rid" class="rid" value="<?php echo esc_attr( $open_table_id ); ?>">
			<input type="hidden" name="txtDateFormat" class="txtDateFormat" value="yyyy-mm-dd">
			<input type="hidden" name="RestaurantReferralID" class="RestaurantReferralID" value="<?php echo esc_attr( $open_table_id ); ?>">
		</form>
	</div>
<?php } ?>