<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

// Get page ID
$page_id = get_the_ID();

$full_address = get_post_meta( $page_id, 'edgtf_listing_single_full_address_meta', true );

if ( ! empty( $full_address ) ) {
	
	// Google map api meta
	$google_maps_api_key = urbango_edge_options()->getOptionValue( 'google_maps_api_key' );
	
	// Contact details meta
	$phone_meta    = get_post_meta( $page_id, 'edgtf_listing_single_contact_phone_meta', true );
	$email_meta    = get_post_meta( $page_id, 'edgtf_listing_single_contact_email_meta', true );
	$site_url_meta = get_post_meta( $page_id, 'edgtf_listing_single_contact_site_url_meta', true );
	
	// Socials meta
	$socials_meta = array();
	
	$facebook_meta = get_post_meta( $page_id, 'edgtf_listing_single_contact_facebook_meta', true );
	if ( ! empty( $facebook_meta ) ) {
		$socials_meta[] = array(
			'label' => 'facebook',
			'icon'  => 'facebook-f',
			'link'  => $facebook_meta
		);
	}
	
	$twitter_meta = get_post_meta( $page_id, 'edgtf_listing_single_contact_twitter_meta', true );
	if ( ! empty( $twitter_meta ) ) {
		$socials_meta[] = array(
			'label' => 'twitter',
			'icon'  => 'twitter',
			'link'  => $twitter_meta
		);
	}
	
	$instagram_meta = get_post_meta( $page_id, 'edgtf_listing_single_contact_instagram_meta', true );
	if ( ! empty( $instagram_meta ) ) {
		$socials_meta[] = array(
			'label' => 'instagram',
			'icon'  => 'instagram',
			'link'  => $instagram_meta
		);
	}
	
	$tripadvisor_meta = get_post_meta( $page_id, 'edgtf_listing_single_contact_tripadvisor_meta', true );
	if ( ! empty( $tripadvisor_meta ) ) {
		$socials_meta[] = array(
			'label' => 'tripadvisor',
			'icon'  => 'tripadvisor',
			'link'  => $tripadvisor_meta
		);
	}
	
	$youtube_meta = get_post_meta( $page_id, 'edgtf_listing_single_contact_youtube_meta', true );
	if ( ! empty( $youtube_meta ) ) {
		$socials_meta[] = array(
			'label' => 'youtube',
			'icon'  => 'youtube',
			'link'  => $youtube_meta
		);
	}
	
	$google_plus_meta = get_post_meta( $page_id, 'edgtf_listing_single_contact_google_plus_meta', true );
	if ( ! empty( $google_plus_meta ) ) {
		$socials_meta[] = array(
			'label' => 'google-plus',
			'icon'  => 'google-plus-g',
			'link'  => $google_plus_meta
		);
	}
	
	$pinterest_meta = get_post_meta( $page_id, 'edgtf_listing_single_contact_pinterest_meta', true );
	if ( ! empty( $pinterest_meta ) ) {
		$socials_meta[] = array(
			'label' => 'pinterest',
			'icon'  => 'pinterest-p',
			'link'  => $pinterest_meta
		);
	}
	
	$yelp_meta = get_post_meta( $page_id, 'edgtf_listing_single_contact_yelp_meta', true );
	if ( ! empty( $yelp_meta ) ) {
		$socials_meta[] = array(
			'label' => 'yelp',
			'icon'  => 'yelp',
			'link'  => $yelp_meta
		);
	}
	?>
	<div class="edgtf-ls-location">
		<div class="edgtf-ls-location-map">
			<?php if ( ! empty( $google_maps_api_key ) ) {
				$google_map_params = array(
					'address1'              => $full_address,
					'map_height'            => '250',
					'enable_direction_link' => 'yes',
					'snazzy_map_style'      => 'yes',
					'snazzy_map_code'       => esc_attr( '[{"featureType":"administrative","elementType":"labels.text.fill","stylers":[{"color":"#444444"}]},{"featureType":"landscape","elementType":"all","stylers":[{"color":"#f3f3f3"}]},{"featureType":"landscape.natural.landcover","elementType":"geometry","stylers":[{"visibility":"off"}]},{"featureType":"landscape.natural.landcover","elementType":"geometry.fill","stylers":[{"visibility":"off"}]},{"featureType":"poi","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"visibility":"on"},{"color":"#d2f9bc"},{"saturation":"-19"}]},{"featureType":"road","elementType":"all","stylers":[{"saturation":-100},{"lightness": 45}]},{"featureType":"road.highway","elementType":"all","stylers":[{"visibility":"simplified"}]},{"featureType":"road.arterial","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"transit","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"water","elementType":"all","stylers":[{"color":"#c0e4f3"},{"visibility": "on"}]}]' )
				);
				
				echo urbango_edge_execute_shortcode( 'edgtf_google_map', $google_map_params );
			} else { ?>
				<p class="edgtf-ls-api-notice"><?php esc_html_e( 'In order for the map functionality to be enabled please input the Google Map API key in the General section of the UrbanGo Options', 'urbango-listing' ); ?></p>
			<?php } ?>
		</div>
	
		<div class="edgtf-ls-location-contact-info">
			<div class="edgtf-ls-location-heading">
				<?php urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/parts-title', '', array( 'title' => esc_attr__( 'Contact info', 'urbango-listing' ) ) ); ?>
				<div class="edgtf-ls-notice">
					<?php
					// Get item claim part
					urbango_listing_get_module_template_part( 'cpt', 'claim', 'templates/claim-opener' );
					
					// Get item report part
					urbango_listing_get_module_template_part( 'cpt', 'report', 'templates/report-opener' );
					?>
				</div>
			</div>
			
			<div class="edgtf-ls-location-cid-holder">
				<p class="edgtf-ls-location-address"><?php echo esc_html( $full_address ); ?></p>
				
				<?php if ( ! empty( $phone_meta ) ) { ?>
					<p class="edgtf-ls-location-phone">
						<a itemprop="url" class="edgtf-ls-location-phone-link" href="tel:<?php echo esc_attr( $phone_meta ); ?>"><?php echo esc_html( $phone_meta ); ?></a>
					</p>
				<?php } ?>
				
				<?php if ( ! empty( $email_meta ) ) { ?>
					<p class="edgtf-ls-location-email">
						<a itemprop="url" class="edgtf-ls-location-email-link" href="mailto:<?php echo esc_attr( $email_meta ); ?>"><?php echo esc_html( $email_meta ); ?></a>
					</p>
				<?php } ?>
				
				<?php if ( ! empty( $site_url_meta ) ) { ?>
					<p class="edgtf-ls-location-site-url">
						<a itemprop="url" class="edgtf-ls-location-site-url-link" href="<?php echo esc_url( $site_url_meta ); ?>" target="_blank"><?php echo esc_url( $site_url_meta ); ?></a>
					</p>
				<?php } ?>
			</div>
			
			<?php
			// Get item business hours part
			urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/business-hours', '', $params );
			?>
			
			<?php if ( ! empty( $socials_meta ) ) { ?>
				<div class="edgtf-ls-location-social">
					<span class="edgtf-ls-location-social-title"><?php esc_html_e( 'Social Profiles:', 'urbango-listing' ); ?></span>
					
					<?php foreach ( $socials_meta as $social ) { ?>
						<a itemprop="url" class="edgtf-ls-location-social-<?php echo esc_attr( $social['label'] ); ?>" href="<?php echo esc_url( $social['link'] ); ?>" target="_blank">
							<i class="fab fa-<?php echo esc_attr( $social['icon'] ); ?>"></i>
						</a>
					<?php }	?>
				</div>
			<?php } ?>
			
			<?php
			// Get item enquiry opener part
			urbango_listing_get_module_template_part( 'modules', 'enquiry', 'templates/enquiry-opener', '', array( 'email_meta' => $email_meta ) );
			?>
		</div>
	</div>
<?php } ?>