<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$additional_info_meta = get_post_meta( get_the_ID(), 'edgtf_listing_single_additional_info_meta', true );

if ( ! empty( $additional_info_meta ) && is_array( $additional_info_meta ) ) { ?>
	<div class="edgtf-ls-additional-info">
		<?php urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/parts-title', '', array( 'title' => esc_attr__( 'Additional info', 'urbango-listing' ) ) ); ?>
		<div class="edgtf-ls-ai-items">
			<?php foreach ( $additional_info_meta as $additional_info ) { ?>
				<div class="edgtf-ls-ai-item">
					<?php if ( isset( $additional_info['label'] ) && ! empty( $additional_info['label'] ) ) { ?>
						<p class="edgtf-ls-ai-label"><?php echo esc_html( $additional_info['label'] ); ?></p>
					<?php } ?>
					<?php if ( isset( $additional_info['value'] ) && ! empty( $additional_info['value'] ) ) {
						$value_have_link = isset( $additional_info['value_link'] ) && ! empty( $additional_info['value_link'] );
						?>
						<p class="edgtf-ls-ai-value">
							<?php if ( $value_have_link ) { ?>
								<a itemprop="url" href="<?php echo esc_url( $additional_info['value_link'] ); ?>">
							<?php } ?>
								<?php echo esc_html( $additional_info['value'] ); ?>
							<?php if ( $value_have_link ) { ?>
								</a>
							<?php } ?>
						</p>
					<?php } ?>
				</div>
			<?php } ?>
		</div>
	</div>
<?php } ?>