<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$title_logo_meta = get_post_meta( get_the_ID(), 'edgtf_listing_single_title_logo_meta', true );
$title_classes   = ! empty( $title_logo_meta ) ? 'edgtf-ls-title-has-logo' : '';

?>
<div class="edgtf-ls-gallery">
	<?php
	// Get item gallery part
	urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/gallery' );
	?>
</div>
<div class="edgtf-ls-title-area-wrapper <?php echo esc_attr( $title_classes ); ?>">
	<div class="edgtf-grid">
		<div class="edgtf-ls-title-area">
			<div class="edgtf-ls-title-left-area">
				<?php
				// Get item logo part
				urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/logo' );
				?>
				<div class="edgtf-ls-title-content">
					<?php
					// Get item title part
					urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/title' );
					?>
					<div class="edgtf-ls-title-info">
						<?php
						// Get item ID part
						urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/item-id' );
						
						// Get item categories part
						urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/category' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="edgtf-grid edgtf-ls-content-area">
	<div class="edgtf-grid-row">
		<div class="edgtf-grid-col-12">
			<div class="edgtf-grid">
				<?php urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/parts-title', '', array( 'title' => esc_html__( 'We are busy updating the listing for you and will be back shortly. -> The listing is currently being updated. We\'ll make sure it\'s available again ASAP.', 'urbango-listing' ) ) ); ?>
				
				<?php
				$button_params = array(
					'link' => esc_url( home_url( '/' ) ),
					'text' => esc_html__( 'Back to home', 'urbango-listing' )
				);
				
				echo urbango_edge_return_button_html( $button_params );
				?>
			</div>
		</div>
	</div>
</div>