<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

?>
<div class="edgtf-full-width">
	<div class="edgtf-full-width-inner">
		<?php
		$urbango_taxonomy_name = '';
		
		if ( is_tax( 'listing-category' ) ) {
			$urbango_taxonomy_name = 'listing-category';
		} else if ( is_tax( 'listing-location' ) ) {
			$urbango_taxonomy_name = 'listing-location';
		} else if ( is_tax( 'listing-tag' ) ) {
			$urbango_taxonomy_name = 'listing-tag';
		} else if ( is_tax( 'listing-amenity' ) ) {
			$urbango_taxonomy_name = 'listing-amenity';
		}
		
		$urbango_author_id = '';
		if ( is_author() ) {
			$author_meta = get_user_by( 'slug', get_query_var( 'author_name' ) );
			
			if ( ! empty( $author_meta ) ) {
				$urbango_author_id = $author_meta->ID;
			}
		}
		
		if ( ! empty( $urbango_author_id ) ) { ?>
			<div class="edgtf-author-page-info">
				<h3 class="edgtf-ap-author-title">
					<span class="edgtf-ap-author-title-label"><?php esc_html_e( 'Listings Owner - ', 'urbango-listing' ); ?></span>
					<span class="edgtf-ap-author-title-name"><?php echo get_the_author_meta( 'display_name', $urbango_author_id); ?></span>
				</h3>
			</div>
		<?php }
		
		urbango_listing_get_archive_listing_item_content( get_queried_object_id(), $urbango_taxonomy_name, $urbango_author_id );
		?>
	</div>
</div>