<?php

namespace UrbanGoListing\CPT\Shortcodes\Listing;

use UrbanGoListing\Lib;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

class ListingSearch implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'edgtf_listing_search';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map( array(
					'name'     => esc_html__( 'Listing Search', 'urbango-listing' ),
					'base'     => $this->getBase(),
					'category' => esc_html__( 'by URBANGO LISTING', 'urbango-listing' ),
					'icon'     => 'icon-wpb-listing-search extended-custom-listing-icon',
					'params'   => array(
						array(
							'type'        => 'dropdown',
							'param_name'  => 'enable_custom_search',
							'heading'     => esc_html__( 'Enable Custom Search', 'urbango-listing' ),
							'description' => esc_html__( 'Enable custom search query as parameter for search', 'urbango-listing' ),
							'value'       => array_flip( urbango_edge_get_yes_no_select_array( false, true ) )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'enable_category',
							'heading'     => esc_html__( 'Enable Category', 'urbango-listing' ),
							'description' => esc_html__( 'Enable category as parameter for search', 'urbango-listing' ),
							'value'       => array_flip( urbango_edge_get_yes_no_select_array( false, true ) )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'enable_location',
							'heading'     => esc_html__( 'Enable Location', 'urbango-listing' ),
							'description' => esc_html__( 'Enable location as parameter for search', 'urbango-listing' ),
							'value'       => array_flip( urbango_edge_get_yes_no_select_array( false, true ) )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'location_field_type',
							'heading'     => esc_html__( 'Location Field Type', 'urbango-listing' ),
							'description' => esc_html__( 'Choose location input field type', 'urbango-listing' ),
							'value'       => array(
								esc_html__( 'Select Box', 'urbango-listing' )             => 'select',
								esc_html__( 'AutoComplete Locations', 'urbango-listing' ) => 'places'
							),
							'dependency'  => array( 'element' => 'enable_location', 'value' => array( 'yes' ) )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'button_text',
							'heading'    => esc_html__( 'Button Text', 'urbango-listing' ),
							'value'      => esc_html__( 'Search', 'urbango-listing' )
						)
					)
				)
			);
		}
	}
	
    public function render($atts, $content = null) {
	    $args   = array(
		    'enable_custom_search' => 'yes',
		    'enable_category'      => 'yes',
		    'enable_location'      => 'yes',
		    'location_field_type'  => 'select',
		    'button_text'          => esc_html__( 'Search', 'urbango-listing' )
	    );
	    $params = shortcode_atts( $args, $atts );
	    
	    $params['holder_classes'] = $this->getHolderClasses( $params );
	    $params['button_params']  = $this->getButtonParams( $params, $args );
	
	    $html = urbango_listing_get_module_template_part( 'cpt-listing', 'listing-search', 'holder', '', $params, array(), false );
	
	    return $html;
    }
	
	/**
	 * Generates holder classes
	 *
	 * @param $params
	 *
	 * @return string
	 */
	public function getHolderClasses( $params ) {
		$classes = array();
		
		if ( $params['enable_custom_search'] === 'yes' ) {
			$classes[] = 'edgtf-custom-search-enabled';
		}
		
		if ( $params['enable_category'] === 'yes' ) {
			$classes[] = 'edgtf-custom-category-enabled';
		}
		
		if ( $params['enable_location'] === 'yes' ) {
			$classes[] = 'edgtf-custom-location-enabled';
		}
		
		return implode( ' ', $classes );
	}
	
	/**
	 * Set button shortcode parameters
	 *
	 * @param $params
	 * @param $args
	 *
	 * @return array
	 */
	public function getButtonParams( $params, $args ) {
		$button_params = array();
		
		$button_params['html_type'] = 'button';
		$button_params['icon_pack'] = 'font_awesome';
		$button_params['fa_icon']   = 'fas fa-search';
		$button_params['text']      = ! empty( $params['button_text'] ) ? $params['button_text'] : $args['button_text'];
		
		return $button_params;
	}
}