<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! empty( $terms ) ) { ?>
	<div class="edgtf-lli-<?php echo esc_attr( $taxonomy_name ); ?>-holder">
		<?php foreach ( $terms as $term ) {
			$term_id = $term->term_id;
			
			$term_custom_icon = get_term_meta( $term_id, 'edgtf_listing_' . esc_attr( $taxonomy_name ) . '_icon_meta', true );
			$term_svg_icon    = get_term_meta( $term_id, 'edgtf_listing_' . esc_attr( $taxonomy_name ) . '_svg_icon_meta', true );
			
			$term_icon = '';
			if ( ! empty( $term_custom_icon ) ) {
				$term_icon = $term_custom_icon;
			}
			
			if ( ! empty( $term_svg_icon ) ) {
				$term_icon = $term_svg_icon;
			}
			
			$item_class = ! empty( $term_icon ) ? 'edgtf-is-icon' : 'edgtf-without-icon';
			?>
			<a itemprop="url" class="edgtf-lli-<?php echo esc_attr( $taxonomy_name ); ?> <?php echo esc_attr( $item_class ); ?>" href="<?php echo esc_url( get_term_link( $term_id ) ); ?>">
				<?php if ( ! empty( $term_svg_icon ) ) {
					echo stripcslashes( preg_replace( '/<script\b[^>]*>(.*?)<\/script>/is', '', $term_icon ) );
				} else if ( ! empty( $term_icon ) ) {
					echo wp_get_attachment_image( $term_icon );
				} else {
					echo esc_html( $term->name );
				} ?>
			</a>
		<?php } ?>
	</div>
<?php } ?>