<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_listing_list_shortcode' ) ) {
	function urbango_listing_add_listing_list_shortcode( $shortcodes_class_name ) {
		$shortcodes = array(
			'UrbanGoListing\CPT\Shortcodes\Listing\ListingList'
		);
		
		$shortcodes_class_name = array_merge( $shortcodes_class_name, $shortcodes );
		
		return $shortcodes_class_name;
	}
	
	add_filter( 'urbango_listing_filter_add_vc_shortcode', 'urbango_listing_add_listing_list_shortcode' );
}

if ( ! function_exists( 'urbango_listing_set_listing_list_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for this shortcode to set our icon for Visual Composer shortcodes panel
	 */
	function urbango_listing_set_listing_list_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-listing-list';
		
		return $shortcodes_icon_class_array;
	}
	
	add_filter( 'urbango_listing_filter_add_vc_shortcodes_custom_icon_class', 'urbango_listing_set_listing_list_icon_class_name_for_vc_shortcodes' );
}

if ( ! function_exists( 'urbango_listing_init_listing_list_ajax_load_more' ) ) {
	function urbango_listing_init_listing_list_ajax_load_more() {
		$shortcode_params  = array();
		
		if ( ! empty( $_POST ) ) {
			foreach ( $_POST as $key => $value ) {
				if ( $key !== '' ) {
					$addUnderscoreBeforeCapitalLetter = preg_replace( '/([A-Z])/', '_$1', $key );
					$setAllLettersToLowercase         = strtolower( $addUnderscoreBeforeCapitalLetter );
					
					$shortcode_params[ $setAllLettersToLowercase ] = $value;
				}
			}
		}
		
		$listing_list = new \UrbanGoListing\CPT\Shortcodes\Listing\ListingList();
		
		$query_array                     = $listing_list->getQueryArray( $shortcode_params );
		$query_results                   = new \WP_Query( $query_array );
		$posts_count                     = $query_results->post_count;
		$shortcode_params['this_object'] = $listing_list;
		
		ob_start();
		
		if ( $query_results->have_posts() ):
			while ( $query_results->have_posts() ) : $query_results->the_post();
				urbango_listing_get_module_template_part( 'cpt-listing', 'listing-list', 'item', '', $shortcode_params );
			endwhile;
		else:
			urbango_listing_get_module_template_part( 'cpt-listing', 'listing-list', 'parts/posts-not-found' );
		endif;
		
		$html = ob_get_contents();
		
		ob_end_clean();
		
		wp_reset_postdata();
		
		$multiple_map_vars = array();
		if ( $shortcode_params['enable_map'] === 'yes' ) {
			$multiple_map_vars = urbango_listing_set_multiple_map_variables( $query_array, true );
		}
		
		$return_obj = array(
			'html'         => $html,
			'mapAddresses' => $multiple_map_vars,
			'postsCount'   => $posts_count
		);
		
		echo json_encode( $return_obj );
		exit;
	}
	
	add_action( 'wp_ajax_nopriv_urbango_listing_init_listing_list_ajax_load_more', 'urbango_listing_init_listing_list_ajax_load_more' );
	add_action( 'wp_ajax_urbango_listing_init_listing_list_ajax_load_more', 'urbango_listing_init_listing_list_ajax_load_more' );
}

if ( ! function_exists( 'urbango_listing_set_listing_list_ajax_save_query' ) ) {
	function urbango_listing_set_listing_list_ajax_save_query() {
		if ( empty( $_POST ) || ! isset( $_POST ) ) {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'All fields are empty, search parameters are not saved', 'urbango-listing' ) );
		} else {
			$data = $_POST;
			
			$search_params = array(
				'order_by'      => isset( $data['order-by'] ) ? $data['order-by'] : '',
				'custom_search' => isset( $data['custom-search'] ) ? $data['custom-search'] : '',
				'category'      => isset( $data['category'] ) ? $data['category'] : '',
				'location'      => isset( $data['location'] ) ? $data['location'] : '',
				'tag'           => isset( $data['tag'] ) ? $data['tag'] : ''
			);
			
			$user_id      = get_current_user_id();
			$user_queries = get_user_meta( $user_id, 'edgtf_user_saved_queries', true );
			
			if ( ! isset( $user_queries ) || empty( $user_queries ) ) {
				$user_queries = array();
			}
			
			$user_queries[] = $search_params;
			
			update_user_meta( $user_id, 'edgtf_user_saved_queries', $user_queries );
			
			end( $user_queries );         // move the internal pointer to the end of the array
			$index = key( $user_queries );
			reset( $user_queries );       // reset pointer of array
			
			$html = '<span class="edgtf-undo-query-save" data-query-id="' . esc_attr( $index ) . '">';
			$html .= '<span class="edgtf-undo-query-message">' . esc_html__( 'Undo', 'urbango-listing' ) . '</span>';
			$html .= '<i class="fa fa-undo" aria-hidden="true"></i>';
			$html .= '</span>';
			
			urbango_listing_get_ajax_status( 'success', esc_html__( 'Query successfully saved.', 'urbango-listing' ), $html );
		}
	}
	
	add_action( 'wp_ajax_urbango_listing_set_listing_list_ajax_save_query', 'urbango_listing_set_listing_list_ajax_save_query' );
}

if ( ! function_exists( 'urbango_listing_set_listing_list_ajax_remove_query' ) ) {
	function urbango_listing_set_listing_list_ajax_remove_query() {
		if ( empty( $_POST ) || ! isset( $_POST ) ) {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'No query saved to be undone.', 'urbango-listing' ) );
		} else {
			$user_id      = get_current_user_id();
			
			$user_queries = get_user_meta( $user_id, 'edgtf_user_saved_queries', true );
			if ( ! isset( $user_queries ) || empty( $user_queries ) ) {
				$user_queries = array();
			} else {
				unset( $user_queries[ $_POST['query_id'] ] );
			}
			
			update_user_meta( $user_id, 'edgtf_user_saved_queries', $user_queries );
			
			urbango_listing_get_ajax_status( 'success', esc_html__( 'Query successfully removed.', 'urbango-listing' ) );
		}
	}
	
	add_action( 'wp_ajax_urbango_listing_set_listing_list_ajax_remove_query', 'urbango_listing_set_listing_list_ajax_remove_query' );
}

if ( ! function_exists( 'urbango_listing_init_listing_list_relation_terms_switcher' ) ) {
	function urbango_listing_init_listing_list_relation_terms_switcher() {
		if ( empty( $_POST ) || ! isset( $_POST ) ) {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'Selected value is empty', 'urbango-listing' ) );
		} else {
			$data = $_POST['data'];
			
			$terms = urbango_listing_get_cpt_taxonomy_items( 'tag', false );
			
			if ( $data !== '-1' ) {
				$relation_terms_meta = get_term_meta( intval( $data ), 'edgtf_listing_category_relation_tags_meta', true );
				$relation_terms      = array();
				
				if ( ! empty( $relation_terms_meta ) ) {
					foreach ( $relation_terms_meta as $relation_term_id ) {
						$relation_terms[ $relation_term_id ] = urbango_listing_get_cpt_taxonomy_name_by_id( $relation_term_id );
					}
				}
			}
			
			$terms = ! empty( $relation_terms ) ? $relation_terms : $terms;
			
			urbango_listing_get_ajax_status( 'success', esc_html__( 'Relation terms successfully send.', 'urbango-listing' ), $terms );
		}
	}
	
	add_action( 'wp_ajax_nopriv_urbango_listing_init_listing_list_relation_terms_switcher', 'urbango_listing_init_listing_list_relation_terms_switcher' );
	add_action( 'wp_ajax_urbango_listing_init_listing_list_relation_terms_switcher', 'urbango_listing_init_listing_list_relation_terms_switcher' );
}

if ( ! function_exists( 'urbango_listing_get_listing_list_query_order_by_array' ) ) {
	/**
	 * Returns array of query order by
	 *
	 * @param bool  $first_empty whether to add empty first member
	 * @param array $additional_elements
	 *
	 * @return array
	 */
	function urbango_listing_get_listing_list_query_order_by_array( $first_empty = false, $additional_elements = array() ) {
		$orderBy = array();
		
		if ( $first_empty ) {
			$orderBy[''] = esc_html__( 'Default', 'urbango-listing' );
		}
		
		$orderBy['date']             = esc_html__( 'Sort by: Date', 'urbango-listing' );
		$orderBy['title']            = esc_html__( 'Sort by: Title', 'urbango-listing' );
		$orderBy['featured-first']   = esc_html__( 'Sort by: Featured Items First', 'urbango-listing' );
		$orderBy['featured-last']    = esc_html__( 'Sort by: Featured Items Last', 'urbango-listing' );
		$orderBy['price-range-high'] = esc_html__( 'Sort by: Price Range from High to Low', 'urbango-listing' );
		$orderBy['price-range-low']  = esc_html__( 'Sort by: Price Range From Low To High', 'urbango-listing' );
		$orderBy['ID']               = esc_html__( 'Sort by: ID', 'urbango-listing' );
		$orderBy['rand']             = esc_html__( 'Sort by: Random', 'urbango-listing' );
		$orderBy['menu_order']       = esc_html__( 'Sort by: Menu Order', 'urbango-listing' );
		
		if ( ! empty( $additional_elements ) ) {
			$orderBy = array_merge( $orderBy, $additional_elements );
		}
		
		return $orderBy;
	}
}
