(function ($) {
	'use strict';
	
	var listingList = {};
	edgtf.modules.listingList = listingList;
	listingList.edgtfInitGeoLocationRangeSlider = edgtfInitGeoLocationRangeSlider;
	listingList.edgtfInitListingListPagination = edgtfInitListingListPagination;
	
	listingList.edgtfOnDocumentReady = edgtfOnDocumentReady;
	listingList.edgtfOnWindowLoad = edgtfOnWindowLoad;
	listingList.edgtfOnWindowScroll = edgtfOnWindowScroll;
	
	$(document).ready(edgtfOnDocumentReady);
	$(window).on('load', edgtfOnWindowLoad);
	$(window).scroll(edgtfOnWindowScroll);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		edgtfInitGeoLocationRangeSlider().init();
		edgtfInitListingListMapSwitcher();
	}
	
	/*
	 All functions to be called on $(window).on('load',) should be in this function
	 */
	function edgtfOnWindowLoad() {
		edgtfInitListingListFilter();
		edgtfInitListingListRelationTermsSwitcher();
		edgtfInitListingListPagination().init();
		edgtfListHoverClass();
	}
	
	/*
	 All functions to be called on $(window).scroll() should be in this function
	 */
	function edgtfOnWindowScroll() {
		edgtfInitListingListPagination().scroll();
	}
	
	/**
	 * Initializes listing list geo location radius functionality
	 */
	function edgtfInitGeoLocationRangeSlider() {
		var holder = $('.edgtf-listing-list-holder.edgtf-ll-with-map.edgtf-ll-with-filter');
		
		var createSlider = function (geoLocationRadius, slider) {
			noUiSlider.create(slider, {
				connect: [true, false],
				start: 0,
				tooltips: true,
				format: {
					from: function (value) {
						return parseFloat(value).toFixed(2);
					},
					to: function (value) {
						return parseFloat(value).toFixed(2);
					}
				},
				range: {
					min: 0,
					max: 50
				}
			});
			
			updateMapRadius(geoLocationRadius, slider);
		};
		
		var updateMapRadius = function (geoLocationRadius, slider) {
			var sliderEventCount = 0;
			
			slider.noUiSlider.on('set', function (values) {
				var geoLocation = geoLocationRadius.data('geo-location');
				
				if (typeof geoLocation === 'object') {
					edgtf.modules.listingMaps.edgtfGoogleMaps.setGeoLocationRadius(geoLocation, values, sliderEventCount > 0);
					sliderEventCount++;
				}
			});
		};
		
		var resetRadius = function (slider) {
			slider.noUiSlider.reset();
		};
		
		var sliderVisibility = function (geoLocationRadius, latlng, visibility) {
			geoLocationRadius.data('geo-location', latlng);
			
			if (visibility) {
				geoLocationRadius.show();
			} else {
				geoLocationRadius.hide();
			}
		};
		
		var disableItemsOutOfRange = function (itemsInArea) {
			var items = holder.find('.edgtf-ll-inner article');
			
			if (items.length && itemsInArea.length > 0) {
				if (!holder.children('.edgtf-ll-out-of-range-holder').length) {
					holder.append('<div class="edgtf-ll-out-of-range-holder"></div>');
				}
				
				var outOfRangeHolder = holder.children('.edgtf-ll-out-of-range-holder'),
					outOfRangeItems = outOfRangeHolder.children('article'),
					inRangeHolder = holder.find('.edgtf-ll-inner');
				
				items.each(function () {
					var thisItem = $(this),
						itemID = thisItem.data('id');
					
					if (itemID !== undefined && itemID !== false) {
						var itemInRange = false;
						
						$.each(itemsInArea, function (i, id) {
							if (parseInt(itemID, 10) === id) {
								itemInRange = true;
								return true;
							}
						});
						
						if (!itemInRange) {
							thisItem.appendTo(outOfRangeHolder);
							
							if (holder.hasClass('edgtf-ll-masonry')) {
								inRangeHolder.isotope('layout');
							}
						}
					}
				});
				
				if (outOfRangeItems.length) {
					outOfRangeItems.each(function () {
						var thisOutItem = $(this),
							outItemID = thisOutItem.data('id'),
							itemInRange = false;
						
						$.each(itemsInArea, function (i, id) {
							if (parseInt(outItemID, 10) === id) {
								itemInRange = true;
								return true;
							}
						});
						
						if (itemInRange) {
							thisOutItem.appendTo(inRangeHolder);
							
							if (holder.hasClass('edgtf-ll-masonry')) {
								inRangeHolder.isotope('layout');
							}
						}
					});
				}
			}
		};
		
		return {
			init: function () {
				if (holder.length) {
					var geoLocationRadius = holder.find('.edgtf-fs-places-geo-radius');
					
					if (geoLocationRadius.length) {
						var slider = document.getElementById('edgtf-range-slider-id');
						
						createSlider(geoLocationRadius, slider);
					}
				}
			},
			reset: function () {
				if (holder.length) {
					var geoLocationRadius = holder.find('.edgtf-fs-places-geo-radius');
					
					if (geoLocationRadius.length && geoLocationRadius.is(':visible')) {
						var slider = document.getElementById('edgtf-range-slider-id');
						
						sliderVisibility(geoLocationRadius, '', false);
						resetRadius(slider);
					}
				}
			},
			showRangeSlider: function (latlng, visibility) {
				if (holder.length) {
					var geoLocationRadius = holder.find('.edgtf-fs-places-geo-radius');
					
					if (geoLocationRadius.length) {
						sliderVisibility(geoLocationRadius, latlng, visibility);
					}
				}
			},
			disableItemsOutOfRange: function (itemsInArea) {
				if (holder.length && typeof itemsInArea === 'object') {
					disableItemsOutOfRange(itemsInArea);
				}
			}
		};
	}
	
	/**
	 * Initializes listing list map switcher functionality
	 */
	function edgtfInitListingListMapSwitcher() {
		var holder = $('.edgtf-listing-list-holder.edgtf-ll-with-map .edgtf-map-switcher');
		
		if (holder.length) {
			holder.each(function () {
				var thisHolder = $(this),
					mainHolder = thisHolder.parents('.edgtf-listing-list-holder'),
					fullMapSwitcher = thisHolder.children('.edgtf-map-switcher-full-map'),
					fullListSwitcher = thisHolder.children('.edgtf-map-switcher-full-list'),
					resetSwitcher = thisHolder.children('.edgtf-map-switcher-reset');
				
				fullMapSwitcher.on('click', function(e){
					e.preventDefault();
					
					fullMapSwitcher.hide();
					fullListSwitcher.show();
					resetSwitcher.show();
					mainHolder.removeClass('edgtf-switch-full-list').addClass('edgtf-switch-full-map');
					edgtf.modules.common.edgtfDisableScroll();
				});
				
				fullListSwitcher.on('click', function(e){
					e.preventDefault();
					
					fullMapSwitcher.show();
					fullListSwitcher.hide();
					resetSwitcher.show();
					mainHolder.removeClass('edgtf-switch-full-map').addClass('edgtf-switch-full-list');
					edgtf.modules.common.edgtfEnableScroll();
				});
				
				resetSwitcher.on('click', function(e){
					e.preventDefault();
					
					fullMapSwitcher.show();
					fullListSwitcher.show();
					resetSwitcher.hide();
					mainHolder.removeClass('edgtf-switch-full-map edgtf-switch-full-list');
					edgtf.modules.common.edgtfEnableScroll();
				});
			});
		}
	}
	
	/**
	 * Initializes filter functionality
	 */
	function edgtfInitListingListFilter() {
		var holder = $('.edgtf-ll-filter-holder');
		
		if (holder.length) {
			holder.each(function () {
				var thisHolder = $(this),
					thisListingList = thisHolder.parents('.edgtf-listing-list-holder'),
					defaultItemLayoutData = thisListingList.data('item-layout'),
					defaultNumberOfColumnsData = thisListingList.data('number-of-columns'),
					searchButton = thisHolder.find('.edgtf-ll-filter-search'),
					saveButton = thisHolder.find('.edgtf-ll-filter-save'),
					resetButton = thisHolder.find('.edgtf-ll-filter-reset'),
					resultsMessage = thisHolder.find('.edgtf-filter-query-results');
				
				// Filter by attributes
				var	select2Fields = thisHolder.find('.edgtf-fs-inner.edgtf-fs-is-select2'),
					select2FieldsExists = select2Fields.length,
					checkboxFields = thisHolder.find('.edgtf-fs-inner.edgtf-fs-is-checkbox'),
					checkboxFieldsExists = checkboxFields.length,
					inputTextFields = thisHolder.find('.edgtf-fs-inner.edgtf-fs-is-text'),
					inputTextFieldsExists = inputTextFields.length,
					switchLayout = thisHolder.find('.edgtf-filter-section-switch-layout'),
					switchLayoutIsSet = switchLayout.length,
					inputPlacesFields = thisHolder.find('.edgtf-fs-inner.edgtf-fs-is-places'),
					inputPlacesFieldsExists = inputPlacesFields.length;
				
				if (select2FieldsExists) {
					select2Fields.each(function () {
						var select2Item = $(this);
						
						initSelect2Field(select2Item, select2Item.data('type'));
					});
				}
				
				// Init search functionality
				searchButton.on('click', function (e) {
					e.preventDefault();
					
					if (select2FieldsExists) {
						select2Fields.each(function () {
							var select2Item = $(this),
								select2Type = select2Item.data('type');
							
							thisListingList.data(select2Type, select2Item.data(select2Type));
						});
					}
					
					if (checkboxFieldsExists) {
						checkboxFields.each(function () {
							var checkboxItem = $(this),
								checkedCBItems = [];
							
							checkboxItem.find('input[type="checkbox"]:checked').each(function () {
								checkedCBItems.push(parseInt($(this).data('id')));
							});
							
							if (checkedCBItems.length) {
								checkedCBItems = checkedCBItems.join(',');
							}
							
							thisListingList.data(checkboxItem.data('type'), checkedCBItems);
						});
					}
					
					if (inputTextFieldsExists) {
						inputTextFields.each(function () {
							var inputTextItem = $(this),
								inputTextValue = inputTextItem.find('input[type="text"]').val();
							
							thisListingList.data(inputTextItem.data('type'), inputTextValue);
						});
					}
					
					if (inputPlacesFieldsExists) {
						inputPlacesFields.each(function () {
							var inputPlaceItem = $(this),
								inputPlaceValue = inputPlaceItem.find('input[type="text"]').val();
							
							thisListingList.data(inputPlaceItem.data('type'), inputPlaceValue);
						});
					}
					
					edgtfInitListingListPagination().getMainPagFunction(thisListingList, 1, true);
					
					resetButton.addClass('edgtf-ll-filter-is-searched');
				});
				
				// Init save functionality
				saveButton.on('click', function (e) {
					e.preventDefault();
					
					if (edgtf.body.hasClass('logged-in')) {
						resultsMessage.html('<span class="fa fa-spinner fa-spin" aria-hidden="true"></span>');
						
						var ajaxData = {
							action: 'urbango_listing_set_listing_list_ajax_save_query'
						};
						
						if (select2FieldsExists) {
							select2Fields.each(function () {
								var select2Item = $(this),
									select2Type = select2Item.data('type');
								
								ajaxData[select2Type] = select2Item.data(select2Type);
							});
						}
						
						if (checkboxFieldsExists) {
							checkboxFields.each(function () {
								var checkboxItem = $(this),
									checkedCBItems = [];
								
								checkboxItem.find('input[type="checkbox"]:checked').each(function () {
									checkedCBItems.push(parseInt($(this).data('id')));
								});
								
								if (checkedCBItems.length) {
									checkedCBItems = checkedCBItems.join(',');
									
									ajaxData[checkboxItem.data('type')] = checkedCBItems;
								}
							});
						}
						
						if (inputTextFieldsExists) {
							inputTextFields.each(function () {
								var inputTextItem = $(this);
								
								ajaxData[inputTextItem.data('type')] = inputTextItem.find('input[type="text"]').val();
							});
						}
						
						if (inputPlacesFieldsExists) {
							inputPlacesFields.each(function () {
								var inputPlaceItem = $(this);
								
								ajaxData[inputPlaceItem.data('type')] = inputPlaceItem.find('input[type="text"]').val();
							});
						}
						
						$.ajax({
							type: 'POST',
							data: ajaxData,
							url: edgtfGlobalVars.vars.edgtfAjaxUrl,
							success: function (data) {
								var response = JSON.parse(data);

								resultsMessage.html('<span class="edgtf-filter-result-message">' + response.message + '</span>');
								resultsMessage.append(response.data);

								edgtfInitUndoQueryButton(resultsMessage.parent());
							}
						});
					} else {
						// Trigger event.
						$(document.body).trigger('open_user_login_trigger');
					}
				});
				
				// Init reset functionality
				resetButton.on('click', function (e) {
					e.preventDefault();
					
					if (select2FieldsExists) {
						select2Fields.each(function () {
							var select2Item = $(this),
								select2Type = select2Item.data('type');
							
							resetSelect2Field(select2Item, select2Type, select2Item.data('default-' + select2Type));
						});
					}
					
					if (checkboxFieldsExists) {
						checkboxFields.each(function () {
							$(this).find('input[type="checkbox"]').each(function () {
								$(this).prop('checked', false);
							});
						});
					}
					
					if (inputTextFieldsExists) {
						inputTextFields.each(function () {
							$(this).find('input[type="text"]').val('');
						});
					}
					
					if (inputPlacesFieldsExists) {
						inputPlacesFields.each(function () {
							$(this).find('input[type="text"]').val('');
						});
					}
					
					if (typeof edgtfInitListingListRelationTermsSwitcher === 'function') {
						edgtfInitListingListRelationTermsSwitcher(true);
					}
					
					if (resetButton.hasClass('edgtf-ll-filter-is-searched')) {
						resetButton.removeClass('edgtf-ll-filter-is-searched');
						
						searchButton.trigger('click');
					}
				});
				
				// Init switch layout functionality
				if (switchLayoutIsSet) {
					var standardLayoutLink = switchLayout.find('.edgtf-fs-sl-standard'),
						simpleLayoutLink = switchLayout.find('.edgtf-fs-sl-simple');
					
					if (defaultItemLayoutData.indexOf('standard') !== -1) {
						standardLayoutLink.addClass('edgtf-active');
					} else if (defaultItemLayoutData.indexOf('simple') !== -1) {
						simpleLayoutLink.addClass('edgtf-active');
					}
					
					standardLayoutLink.on('click', function (e) {
						e.preventDefault();
						
						var currentItemLayoutData = thisListingList.data('item-layout'),
							currentNumberOfColumnsData = thisListingList.data('number-of-columns');
						
						if (currentItemLayoutData !== 'standard') {
							standardLayoutLink.addClass('edgtf-active');
							simpleLayoutLink.removeClass('edgtf-active');
							
							thisListingList.data('item-layout', 'standard');
							thisListingList.data('number-of-columns', defaultNumberOfColumnsData);
							
							thisListingList.removeClass('edgtf-ll-layout-' + currentItemLayoutData + ' edgtf-' + currentNumberOfColumnsData + '-columns').addClass('edgtf-ll-layout-standard edgtf-' + defaultNumberOfColumnsData + '-columns');
						}
					});
					
					simpleLayoutLink.on('click', function (e) {
						e.preventDefault();
						
						var currentItemLayoutData = thisListingList.data('item-layout'),
							currentNumberOfColumnsData = thisListingList.data('number-of-columns');
						
						if (currentItemLayoutData !== 'simple') {
							simpleLayoutLink.addClass('edgtf-active');
							standardLayoutLink.removeClass('edgtf-active');
							
							thisListingList.data('item-layout', 'simple');
							thisListingList.data('number-of-columns', '1');
							
							thisListingList.removeClass('edgtf-ll-layout-' + currentItemLayoutData + ' edgtf-' + currentNumberOfColumnsData + '-columns').addClass('edgtf-ll-layout-simple edgtf-one-columns');
						}
					});
				}
				
				// Init geolocation and places functionality for location
				if(inputPlacesFieldsExists) {
					var placesInput = inputPlacesFields.find('input[type="text"]'),
						placesInputValue = placesInput.val(),
						placesInputID = document.getElementById('edgtf-fs-places-location'),
						geoLocationResetLink = inputPlacesFields.find('.edgtf-fs-places-reset'),
						geoLocationLink = inputPlacesFields.find('.edgtf-fs-places-geo'),
						geoLocationLinkIcon = geoLocationLink.children('.edgtf-fs-places-icon');
					
					if (placesInput.length) {
						edgtf.modules.listingMaps.edgtfGoogleMaps.createAutocompletePlaces(placesInputID, thisListingList);
					}
					
					if (placesInputValue.length && thisListingList.hasClass('edgtf-ll-with-map')) {
						geoLocationResetLink.show();
						edgtf.modules.listingMaps.edgtfGoogleMaps.centerOnForwardAddressLocation(placesInputValue);
					}
					
					geoLocationResetLink.on('click', function (e) {
						e.preventDefault();
						
						placesInput.val('');
						geoLocationResetLink.hide();
						
						edgtfInitGeoLocationRangeSlider().reset();
					});
					
					geoLocationLink.on('click', function (e) {
						e.preventDefault();
						
						if (typeof google === 'object' && typeof navigator === 'object') {
							geoLocationResetLink.show();
							edgtf.modules.listingMaps.edgtfGoogleMaps.centerOnCurrentLocation(true, placesInput, geoLocationLinkIcon, thisListingList);
						}
					});
				}
			});
		}
		
		function initSelect2Field(selectElement, paramName) {
			var select2Field = selectElement.find('select');
			
			if (select2Field.length) {
				select2Field.select2().on('select2:select', function (e) {
					var selectedElement = $(e.currentTarget),
						selectVal = selectedElement.val();
					
					selectElement.data(paramName, selectVal);
				});
			}
		}
		
		function resetSelect2Field(selectElement, selectParam, selectValue) {
			var select2Field = selectElement.find('select');
			
			select2Field.val(selectValue).trigger('change');
			selectElement.data(selectParam, selectValue);
		}
		
		function edgtfInitUndoQueryButton(queryHolder) {
			var undoQueryButton = queryHolder.find('.edgtf-undo-query-save'),
				resultHolder = queryHolder.find('.edgtf-filter-query-results');
			
			undoQueryButton.on('click', function () {
				resultHolder.html('<span class="fa fa-spinner fa-spin" aria-hidden="true"></span>');
				
				var ajaxData = {
					action: 'urbango_listing_set_listing_list_ajax_remove_query',
					query_id: undoQueryButton.data('query-id')
				};
				
				$.ajax({
					type: 'POST',
					data: ajaxData,
					url: edgtfGlobalVars.vars.edgtfAjaxUrl,
					success: function (data) {
						var response = JSON.parse(data);
						
						resultHolder.html('<span class="edgtf-filter-result-message">' + response.message + '</span>').append(response.data);
					}
				});
			});
		}
	}
	
	/**
	 * Initializes listing list relation terms switcher functionality
	 */
	function edgtfInitListingListRelationTermsSwitcher($reset) {
		var holder = $('.edgtf-ll-filter-holder');
		
		if (holder.length) {
			holder.each(function () {
				var thisHolder = $(this),
					categoryHolder = thisHolder.find('.edgtf-filter-section.edgtf-filter-section-category'),
					tagHolder = thisHolder.find('.edgtf-filter-section.edgtf-filter-section-tag');
				
				if (categoryHolder.length && tagHolder.length) {
					var categorySelect = categoryHolder.find('select'),
						tagItems = tagHolder.find('.edgtf-fs-cb-items'),
						tagItem = tagItems.children();
					
					if (tagItem.length > 24) { // 24 is sum of max items inside tags visible area
						tagItems.addClass('edgtf-all');
					}
					
					if ($reset) {
						tagItem.removeClass('edgtf-hide edgtf-show');
					}
					
					categorySelect.select2().on('select2:select', function (e) {
						var selectVal = $(e.currentTarget).val();
						
						tagItems.removeClass('edgtf-all').addClass('edgtf-loading').append('<span class="edgtf-loading-spinner fa fa-spinner fa-spin" aria-hidden="true"></span>');
						
						var ajaxData = {
							action: 'urbango_listing_init_listing_list_relation_terms_switcher',
							data: selectVal.length > 0 ? selectVal : '-1'
						};
						
						$.ajax({
							type: 'POST',
							data: ajaxData,
							url: edgtfGlobalVars.vars.edgtfAjaxUrl,
							success: function (data) {
								var response = JSON.parse(data),
									responseData = response.data;
								
								tagItem.each(function () {
									var thisTagItem = $(this),
										tagInputField = thisTagItem.find('input[type="checkbox"]');
									
									thisTagItem.addClass('edgtf-hide');
									
									$.each(responseData, function (index, value) {
										if (tagInputField.data('id') === parseInt(index, 10)) {
											thisTagItem.removeClass('edgtf-hide').addClass('edgtf-show');
										}
									});
								});
								
								if (selectVal.length <= 0 && tagItem.length > 24) {
									tagItems.addClass('edgtf-all');
								}
								
								tagItems.removeClass('edgtf-loading').find('.edgtf-loading-spinner').remove();
							}
						});
					});
				}
			});
		}
	}
	
	/**
	 * Initializes pagination functionality
	 */
	function edgtfInitListingListPagination() {
		var listingList = $('.edgtf-listing-list-holder');
		
		var initStandardPagination = function (thisListingList) {
			var standardLink = thisListingList.find('.edgtf-ll-standard-pagination li');
			
			if (standardLink.length) {
				standardLink.each(function () {
					var thisLink = $(this).children('a'),
						pagedLink = 1;
					
					thisLink.on('click', function (e) {
						e.preventDefault();
						e.stopPropagation();
						
						if (typeof thisLink.data('paged') !== 'undefined' && thisLink.data('paged') !== false) {
							pagedLink = thisLink.data('paged');
						}
						
						initMainPagFunctionality(thisListingList, pagedLink);
					});
				});
			}
		};
		
		var initLoadMorePagination = function (thisListingList) {
			var loadMoreButton = thisListingList.find('.edgtf-ll-load-more a');
			
			loadMoreButton.on('click', function (e) {
				e.preventDefault();
				e.stopPropagation();
				
				initMainPagFunctionality(thisListingList);
			});
		};
		
		var initInifiteScrollPagination = function (thisListingList) {
			var listingListHeight = thisListingList.outerHeight(),
				listingListTopOffest = thisListingList.offset().top,
				listingListPosition = listingListHeight + listingListTopOffest - edgtfGlobalVars.vars.edgtfAddForAdminBar;
			
			if (!thisListingList.hasClass('edgtf-ll-infinite-scroll-started') && edgtf.scroll + edgtf.windowHeight > listingListPosition) {
				initMainPagFunctionality(thisListingList);
			}
		};
		
		var initMainPagFunctionality = function (thisListingList, pagedLink, filterTrigger, locationObject) {
			var thisListingListInner = thisListingList.find('.edgtf-ll-inner'),
				nextPage,
				maxNumPages;
			
			if (typeof locationObject === 'object') {
				var currentLocation = thisListingList.data('location');
				
				if (currentLocation !== undefined && currentLocation.indexOf(locationObject[0]) > -1) {
					return;
				} else {
					thisListingList.data('location', locationObject[0]);
				}
			}
			
			if (typeof thisListingList.data('max-num-pages') !== 'undefined' && thisListingList.data('max-num-pages') !== false) {
				maxNumPages = thisListingList.data('max-num-pages');
			}
			
			if (thisListingList.hasClass('edgtf-ll-pag-standard')) {
				thisListingList.data('next-page', pagedLink);
			}
			
			if (thisListingList.hasClass('edgtf-ll-pag-infinite-scroll')) {
				thisListingList.addClass('edgtf-ll-infinite-scroll-started');
			}
			
			if (pagedLink === 1) {
				thisListingList.data('next-page', pagedLink);
			}
			
			var loadMoreData = edgtf.modules.common.getLoadMoreData(thisListingList),
				loadingItem = thisListingList.find('.edgtf-ll-loading');
			
			nextPage = loadMoreData.nextPage;
			if (nextPage <= maxNumPages || maxNumPages === 0) {
				if (filterTrigger && nextPage === 1) {
					loadingItem.css('top', thisListingList.find('.edgtf-ll-filter-holder').outerHeight() + 60).addClass('edgtf-showing edgtf-fade-trigger');
					thisListingList.addClass('edgtf-fade-trigger-animate');
				} else {
					if (thisListingList.hasClass('edgtf-ll-pag-standard')) {
						loadingItem.addClass('edgtf-showing edgtf-fade-trigger');
						thisListingList.addClass('edgtf-fade-trigger-animate');
					} else {
						loadingItem.addClass('edgtf-showing');
						thisListingList.find('.edgtf-ll-load-more-holder').hide();
					}
				}
				
				var ajaxData = edgtf.modules.common.setLoadMoreAjaxData(loadMoreData, 'urbango_listing_init_listing_list_ajax_load_more');
				
				$.ajax({
					type: 'POST',
					data: ajaxData,
					url: edgtfGlobalVars.vars.edgtfAjaxUrl,
					success: function (data) {
						if (!thisListingList.hasClass('edgtf-ll-pag-standard')) {
							nextPage++;
						}
						
						thisListingList.data('next-page', nextPage);
						
						var response = $.parseJSON(data),
							responseHtml = response.html;
						
						//get map items
						var mapObjs = response.mapAddresses,
							mapAddresses = '';
						
						if (mapObjs !== null && mapObjs['addresses'] !== undefined) {
							mapAddresses = mapObjs['addresses'];
						}
						
						if (thisListingList.hasClass('edgtf-ll-pag-standard') || pagedLink === 1) {
							edgtfInitStandardPaginationLinkChanges(thisListingList, maxNumPages, nextPage);
							
							thisListingList.waitForImages(function () {
								if (thisListingList.hasClass('edgtf-ll-masonry')) {
									edgtfInitHtmlIsotopeNewContent(thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject);
								} else if (thisListingList.hasClass('edgtf-ll-gallery') && thisListingList.hasClass('edgtf-ll-has-filter')) {
									edgtfInitHtmlIsotopeNewContent(thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject);
								} else {
									edgtfInitHtmlGalleryNewContent(thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject);
								}
							});
						} else {
							thisListingList.waitForImages(function () {
								if (thisListingList.hasClass('edgtf-ll-masonry')) {
									if (pagedLink === 1) {
										edgtfInitHtmlIsotopeNewContent(thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject);
									} else {
										edgtfInitAppendIsotopeNewContent(thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject);
									}
								} else if (thisListingList.hasClass('edgtf-ll-gallery') && thisListingList.hasClass('edgtf-ll-has-filter') && pagedLink !== 1) {
									edgtfInitAppendIsotopeNewContent(thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject);
								} else {
									edgtfInitAppendGalleryNewContent(thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject);
								}
							});
						}
						
						if (thisListingList.hasClass('edgtf-ll-infinite-scroll-started')) {
							thisListingList.removeClass('edgtf-ll-infinite-scroll-started');
						}
						
						if (response.postsCount < 1 || response.postsCount < thisListingList.data('number-of-items')) {
							thisListingList.find('.edgtf-ll-load-more-holder').hide();
						} else {
							thisListingList.find('.edgtf-ll-load-more-holder').show();
						}
					}
				});
			}
			
			if (pagedLink === 1) {
				thisListingList.find('.edgtf-ll-load-more-holder').show();
			}
			
			if (nextPage === maxNumPages) {
				thisListingList.find('.edgtf-ll-load-more-holder').hide();
			}
		};
		
		var edgtfInitStandardPaginationLinkChanges = function (thisListingList, maxNumPages, nextPage) {
			var standardPagHolder = thisListingList.find('.edgtf-ll-standard-pagination'),
				standardPagNumericItem = standardPagHolder.find('li.edgtf-ll-pag-number'),
				standardPagPrevItem = standardPagHolder.find('li.edgtf-ll-pag-prev a'),
				standardPagNextItem = standardPagHolder.find('li.edgtf-ll-pag-next a');
			
			standardPagNumericItem.removeClass('edgtf-ll-pag-active');
			standardPagNumericItem.eq(nextPage - 1).addClass('edgtf-ll-pag-active');
			
			standardPagPrevItem.data('paged', nextPage - 1);
			standardPagNextItem.data('paged', nextPage + 1);
			
			if (nextPage > 1) {
				standardPagPrevItem.css({'opacity': '1'});
			} else {
				standardPagPrevItem.css({'opacity': '0'});
			}
			
			if (nextPage === maxNumPages) {
				standardPagNextItem.css({'opacity': '0'});
			} else {
				standardPagNextItem.css({'opacity': '1'});
			}
		};
		
		var edgtfInitHtmlIsotopeNewContent = function (thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject) {
			thisListingListInner.find('article').remove();
			thisListingListInner.append(responseHtml);
			edgtf.modules.common.setFixedImageProportionSize(thisListingList, thisListingList.find('article'), thisListingListInner.find('.edgtf-ll-grid-sizer').width());
			
			thisListingListInner.isotope('reloadItems').isotope({sortBy: 'original-order'});
			
			edgtfReInitResultsPostCount(thisListingList, thisListingListInner);
			edgtfReInitMapFunctionality(thisListingList, mapAddresses, locationObject, 'append');
			
			loadingItem.removeClass('edgtf-showing edgtf-fade-trigger');
			thisListingList.removeClass('edgtf-fade-trigger-animate');
			
			setTimeout(function () {
				thisListingListInner.isotope('layout');
				edgtf.modules.common.edgtfInitParallax();
				edgtfListHoverClass();
			}, 600);
		};
		
		var edgtfInitHtmlGalleryNewContent = function (thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject) {
			loadingItem.removeClass('edgtf-showing edgtf-fade-trigger');
			thisListingList.removeClass('edgtf-fade-trigger-animate');
			thisListingListInner.html(responseHtml);
			
			edgtfReInitResultsPostCount(thisListingList, thisListingListInner);
			edgtfReInitMapFunctionality(thisListingList, mapAddresses, locationObject, 'replace');
			
			edgtf.modules.common.edgtfInitParallax();
			edgtfListHoverClass();
		};
		
		var edgtfInitAppendIsotopeNewContent = function (thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject) {
			thisListingListInner.append(responseHtml);
			edgtf.modules.common.setFixedImageProportionSize(thisListingList, thisListingList.find('article'), thisListingListInner.find('.edgtf-ll-grid-sizer').width());
			
			thisListingListInner.isotope('reloadItems').isotope({sortBy: 'original-order'});
			
			edgtfReInitResultsPostCount(thisListingList, thisListingListInner);
			edgtfReInitMapFunctionality(thisListingList, mapAddresses, locationObject, 'append');
			
			loadingItem.removeClass('edgtf-showing');
			
			setTimeout(function () {
				thisListingListInner.isotope('layout');
				edgtf.modules.common.edgtfInitParallax();
				edgtfListHoverClass();
			}, 600);
		};
		
		var edgtfInitAppendGalleryNewContent = function (thisListingList, thisListingListInner, loadingItem, responseHtml, mapAddresses, locationObject) {
			loadingItem.removeClass('edgtf-showing');
			thisListingListInner.append(responseHtml);
			
			edgtfReInitResultsPostCount(thisListingList, thisListingListInner);
			edgtfReInitMapFunctionality(thisListingList, mapAddresses, locationObject, 'append');
			
			edgtf.modules.common.edgtfInitParallax();
			edgtfListHoverClass();
		};
		
		var edgtfReInitResultsPostCount = function (thisListingList, thisListingListInner) {
			if (thisListingList.hasClass('edgtf-ll-with-filter')) {
				var resultsPostCount = thisListingList.find('.edgtf-filter-section-switch-layout .edgtf-fs-sl-count');
				
				if (resultsPostCount.length) {
					var postsCount = parseInt(thisListingListInner.find('article').length, 10);
					
					resultsPostCount.html(postsCount);
				}
			}
		};
		
		var edgtfReInitMapFunctionality = function (thisListingList, mapAddresses, locationObject, type) {
			if (thisListingList.hasClass('edgtf-ll-with-map')) {
				if (mapAddresses !== '') {
					edgtf.modules.listingMaps.edgtfReinitMultipleGoogleMaps(mapAddresses, type);
				}
				
				if (typeof locationObject === 'object') {
					edgtf.modules.listingMaps.edgtfGoogleMaps.centerOnForwardLocation(locationObject[1], locationObject[2], locationObject[0]);
				}
			}
		};
		
		return {
			init: function () {
				if (listingList.length) {
					listingList.each(function () {
						var thisPortList = $(this);
						
						if (thisPortList.hasClass('edgtf-ll-pag-standard')) {
							initStandardPagination(thisPortList);
						}
						
						if (thisPortList.hasClass('edgtf-ll-pag-load-more')) {
							initLoadMorePagination(thisPortList);
						}
						
						if (thisPortList.hasClass('edgtf-ll-pag-infinite-scroll')) {
							initInifiteScrollPagination(thisPortList);
						}
					});
				}
			},
			scroll: function () {
				if (listingList.length) {
					listingList.each(function () {
						var thisListingList = $(this);
						
						if (thisListingList.hasClass('edgtf-ll-pag-infinite-scroll')) {
							initInifiteScrollPagination(thisListingList);
						}
					});
				}
			},
			getMainPagFunction: function (thisListingList, paged, filterTrigger, geoLocationObject) {
				initMainPagFunctionality(thisListingList, paged, filterTrigger, geoLocationObject);
			}
		};
	}

	function edgtfListHoverClass() {
		var lists = $('.edgtf-listing-list-holder');

		lists.length && edgtf.modules.common.edgtfToggleHoverClasses('.edgtf-listing-list-holder', 'article', '.edgtf-lli-image');
    }
	
})(jQuery);