(function ($) {
	'use strict';
	
	var categoryTabs = {};
	edgtf.modules.categoryTabs = categoryTabs;
	
	categoryTabs.edgtfOnDocumentReady = edgtfOnDocumentReady;
	
	$(document).ready(edgtfOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		initCategoryTabsSlider();
	}
	
	function initCategoryTabsSlider() {
		var holder = $('.edgtf-category-tabs-holder');
		
		if (holder.length && edgtf.windowWidth <= 680) {
			holder.each(function () {
				var thisHolder = $(this),
					sliderHolder = thisHolder.children(),
					numberOfItems = thisHolder.find('.edgtf-ct-item').length;
				
				if (numberOfItems > 5) {
					thisHolder.addClass('edgtf-slider-init');
					
					sliderHolder.addClass('edgtf-owl-slider').owlCarousel({
						items: 3,
						loop: true,
						autoplay: true,
						autoplayTimeout: 4000,
						smartSpeed: 800,
						dots: false,
						nav: false,
						onInitialize: function () {
							thisHolder.addClass('edgtf-slider-loaded');
						}
					});
				}
			});
		}
	}
	
})(jQuery);