<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$owner_profile_image  = get_user_meta( $author_id, 'edgtf_owner_profile_image', true );
$social_profile_image = get_user_meta( $author_id, 'social_profile_image', true );

if ( ! empty( $owner_profile_image ) ) {
	$profile_image = wp_get_attachment_image( $owner_profile_image, 'thumbnail' );
} elseif ( $social_profile_image !== '' ) {
	$profile_image = '<img src="' . esc_url( $social_profile_image ) . '" alt="' . esc_attr__( 'Owner Profile Image', 'urbango-listing' ) . '">';
} else {
	$profile_image = get_avatar( $author_id, 106 );
}

?>
<?php if ( ! empty( $profile_image ) ) { ?>
	<div class="edgtf-al-image">
		<a itemprop="url" href="<?php echo esc_url( get_author_posts_url( $author_id ) ); ?>"><?php echo wp_kses_post( $profile_image ); ?></a>
	</div>
<?php } ?>