<?php

namespace UrbanGoListing\CPT\Shortcodes\Listing;

use UrbanGoListing\Lib;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

class AuthorList implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'edgtf_author_list';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map( array(
					'name'     => esc_html__( 'Author List', 'urbango-listing' ),
					'base'     => $this->getBase(),
					'category' => esc_html__( 'by URBANGO LISTING', 'urbango-listing' ),
					'icon'     => 'icon-wpb-author-list extended-custom-listing-icon',
					'params'   => array(
						array(
							'type'        => 'dropdown',
							'param_name'  => 'number_of_columns',
							'heading'     => esc_html__( 'Number of Columns', 'urbango-listing' ),
							'description' => esc_html__( 'Set number of columns for your list. Default value is three', 'urbango-listing' ),
							'value'       => array_flip( urbango_edge_get_number_of_columns_array( true ) )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'space_between_items',
							'heading'     => esc_html__( 'Space Between Items', 'urbango-listing' ),
							'description' => esc_html__( 'Set space size between items for your list. Default value is normal', 'urbango-listing' ),
							'value'       => array_flip( urbango_edge_get_space_between_items_array( true ) ),
							'save_always' => true
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'number_of_items',
							'heading'     => esc_html__( 'Number of Items', 'urbango-listing' ),
							'description' => esc_html__( 'Set number of items for your list', 'urbango-listing' )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'author_ids',
							'heading'     => esc_html__( 'Author Ids', 'urbango-listing' ),
							'description' => esc_html__( 'Enter the author ids you want to display, separated by commas (leave empty for showing all authors)', 'urbango-listing' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'title_tag',
							'heading'     => esc_html__( 'Title Tag', 'urbango-listing' ),
							'value'       => array_flip( urbango_edge_get_title_tag( true, array( 'p' => 'p' ) ) ),
							'dependency'  => array( 'element' => 'enable_title', 'value' => array( 'yes' ) ),
							'save_always' => true
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'excerpt_length',
							'heading'     => esc_html__( 'Excerpt Length', 'urbango-listing' ),
							'description' => esc_html__( 'Set number of characters', 'urbango-listing' )
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'number_of_columns'   => 'three',
			'space_between_items' => 'normal',
			'number_of_items'     => '9',
			'author_ids'          => '',
			'title_tag'           => 'h5',
			'excerpt_length'      => ''
		);
		$params = shortcode_atts( $args, $atts );
		
		/***
		 * @params author_results
		 * @params holder_classes
		 */
		$additional_params = array();
		
		$additional_params['author_results'] = $this->getAuthorArray( $params );
		$additional_params['holder_classes'] = $this->getHolderClasses( $params, $args );
		
		$html = urbango_listing_get_module_template_part( 'cpt-listing', 'author-list', 'holder', '', $params, $additional_params, false );
		
		return $html;
	}
	
	/**
	 * Generates author results
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function getAuthorArray( $params ) {
		$users_list      = urbango_listing_get_all_users( false, array( 'role__in' => array( 'administrator', 'owner' ) ) );
		$users_id        = array();
		$number_of_items = intval( $params['number_of_items'] );
		$author_ids      = ! empty( $params['author_ids'] ) ? explode( ',', str_replace( ' ', '', $params['author_ids'] ) ) : array();
		
		if ( ! empty( $users_list ) ) {
			$i = 0;
			
			foreach ( $users_list as $id => $title ) {
				
				if ( $i >= $number_of_items ) {
					continue;
				}
				
				$users_id[] = $id;
				$i++;
			}
		}
		
		if ( ! empty( $author_ids ) ) {
			$users_id = $author_ids;
		}
	
		return $users_id;
	}
	
	/**
	 * Generates holder classes
	 *
	 * @param $params
	 * @param $args
	 *
	 * @return string
	 */
	public function getHolderClasses( $params, $args ) {
		$classes = array();
		
		$classes[] = ! empty( $params['number_of_columns'] ) ? 'edgtf-' . $params['number_of_columns'] . '-columns' : 'edgtf-' . $args['number_of_columns'] . '-columns';
		$classes[] = ! empty( $params['space_between_items'] ) ? 'edgtf-' . $params['space_between_items'] . '-space' : 'edgtf-' . $args['space_between_items'] . '-space';
		
		return implode( ' ', $classes );
	}
}
