<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_dashboard_add_listing_fields' ) ) {
	function urbango_listing_dashboard_add_listing_fields( $params ) {
		extract( $params );
		
		$add_listing = urbango_edge_add_dashboard_fields(
			array(
				'name' => 'add_listing'
			)
		);
		
		$add_listing_form = urbango_edge_add_dashboard_form(
			array(
				'name'         => 'add_listing_form',
				'form_id'      => 'edgtf-listing-add-listing-form',
				'form_action'  => 'urbango_listing_add_listing',
				'button_label' => esc_html__( 'Create Listing', 'urbango-listing' ),
				'button_args'  => array(
					'data-updating-text' => esc_html__( 'Creating Listing', 'urbango-listing' ),
					'data-updated-text'  => esc_html__( 'Listing Created', 'urbango-listing' ),
				),
				'parent'       => $add_listing
			)
		);
		
		// General front-end section - begin
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_general_section',
				'title'  => esc_html__( 'General Section', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-general-section',
					'icon_class'   => 'far fa-list-alt'
				)
			)
		);
		
		if ( urbango_listing_check_if_user_has_featured_items() || urbango_listing_check_is_user_admin() ) {
			urbango_edge_add_dashboard_field(
				array(
					'name'    => 'listing_is_featured',
					'type'    => 'select',
					'label'   => esc_html__( 'Listing Is Featured', 'urbango-listing' ),
					'options' => urbango_edge_get_yes_no_select_array(),
					'parent'  => $add_listing_form,
					'args'    => array(
						'select2'      => true,
						'custom_class' => 'edgtf-listing-is-featured'
					)
				)
			);
		}
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_id_default',
				'type'   => 'text',
				'label'  => esc_html__( 'Listing Item ID', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'    => array(
					'custom_class' => 'edgtf-listing-id'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_title_default',
				'type'   => 'text',
				'label'  => esc_html__( 'Title', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-title'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_description_default',
				'type'   => 'textarea',
				'label'  => esc_html__( 'Description', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-description'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_excerpt_default',
				'type'   => 'textarea',
				'label'  => esc_html__( 'Excerpt', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-excerpt'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_title_logo',
				'type'   => 'image',
				'label'  => esc_html__( 'Title Logo Image', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-title-logo'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_featured_image_default',
				'type'   => 'image',
				'label'  => esc_html__( 'Featured Image', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-featured-image'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'    => 'listing_single_price_range',
				'type'    => 'select',
				'label'   => esc_html__( 'Price Range', 'urbango-listing' ),
				'options' => urbango_listing_get_listing_price_range(),
				'parent'  => $add_listing_form,
				'args'    => array(
					'select2'      => true,
					'custom_class' => 'edgtf-listing-price-range'
				)
			)
		);
		
		// General front-end section - end
		
		// Gallery front-end section - begin
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_gallery_section',
				'title'  => esc_html__( 'Gallery Section', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-gallery-section',
					'icon_class'   => 'far fa-images'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_gallery_images',
				'type'   => 'gallery',
				'label'  => esc_html__( 'Gallery Images', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-gallery-images edgtf-dashboard-field-full-width'
				)
			)
		);
		
		// Gallery front-end section - end
		
		// Category front-end section - begin
		
		$category_meta = urbango_listing_get_cpt_taxonomy_items( 'category', false );
		$categories    = ! empty( $category_meta ) ? $category_meta : array();
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_category_section',
				'title'  => esc_html__( 'Category Section', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-category-section',
					'icon_class'   => 'far fa-folder'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'    => 'listing_category_taxonomy',
				'type'    => 'checkboxgroup',
				'value'   => '',
				'label'   => esc_html__( 'Category', 'urbango-listing' ),
				'options' => $categories,
				'parent'  => $add_listing_form,
				'args'    => array(
					'custom_class' => 'edgtf-listing-category edgtf-dashboard-field-full-width'
				)
			)
		);
		
		// Category front-end section - end
		
		// Tag front-end section - begin
		
		$tag_meta = urbango_listing_get_cpt_taxonomy_items( 'tag', false );
		$tags     = ! empty( $tag_meta ) ? $tag_meta : array();
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_tag_section',
				'title'  => esc_html__( 'Tag Section', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-tag-section',
					'icon_class'   => 'far fa-bookmark'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'    => 'listing_tag_taxonomy',
				'type'    => 'checkboxgroup',
				'value'   => '',
				'label'   => esc_html__( 'Tag', 'urbango-listing' ),
				'options' => $tags,
				'parent'  => $add_listing_form,
				'args'    => array(
					'custom_class' => 'edgtf-listing-tag edgtf-dashboard-field-full-width'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'        => 'listing_tag_new_item',
				'type'        => 'text',
				'value'       => '',
				'label'       => esc_html__( 'Add New Tag', 'urbango-listing' ),
				'description' => esc_html__( 'If there is no tags in the list, be free to add it. For multiple tags just separate it with comma. That tags will automatically assign to your listing item', 'urbango-listing' ),
				'parent'      => $add_listing_form,
				'args'         => array(
					'custom_class' => 'edgtf-listing-new-tag'
				)
			)
		);
		
		// Tag front-end section - end
		
		// Location front-end section - begin
		
		$location_meta = urbango_listing_get_cpt_taxonomy_items( 'location' );
		$locations     = ! empty( $location_meta ) ? $location_meta : array();
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_location_section',
				'title'  => esc_html__( 'Location Section', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-location-section',
					'icon_class'   => 'far fa-map'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'    => 'listing_location_taxonomy',
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'City', 'urbango-listing' ),
				'options' => $locations,
				'parent'  => $add_listing_form,
				'args'    => array(
					'select2'      => true,
					'custom_class' => 'edgtf-listing-location'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'        => 'listing_location_new_item',
				'type'        => 'text',
				'value'       => '',
				'label'       => esc_html__( 'Add New City', 'urbango-listing' ),
				'description' => esc_html__( 'If there is no city in the list, be free to add it. This city will automatically assign to your listing item', 'urbango-listing' ),
				'parent'      => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-new-location'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_full_address',
				'type'   => 'address',
				'label'  => esc_html__( 'Full Address', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'latitude_field'  => 'listing_single_full_address_latitude',
					'longitude_field' => 'listing_single_full_address_longitude',
					'custom_class'    => 'edgtf-listing-full-address edgtf-dashboard-field-full-width'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_full_address_latitude',
				'type'   => 'text',
				'label'  => esc_html__( 'Latitude', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-dashboard-address-elements edgtf-listing-latitude-address'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_full_address_longitude',
				'type'   => 'text',
				'label'  => esc_html__( 'Longitude', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-dashboard-address-elements edgtf-listing-longitude-address'
				)
			)
		);
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_location_contact_section',
				'title'  => esc_html__( 'Contact Information', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-location-contact-section',
					'icon_class'   => 'far fa-envelope'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_phone',
				'type'   => 'text',
				'label'  => esc_html__( 'Phone', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-phone'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_email',
				'type'   => 'text',
				'label'  => esc_html__( 'Email', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-email'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_site_url',
				'type'   => 'text',
				'label'  => esc_html__( 'Site URL', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-site-url'
				)
			)
		);
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_location_social_section',
				'title'  => esc_html__( 'Social Information', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-contact-social-section',
					'icon_class'   => 'far fa-share-square'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_facebook',
				'type'   => 'text',
				'label'  => esc_html__( 'Facebook Link', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-facebook'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_twitter',
				'type'   => 'text',
				'label'  => esc_html__( 'Twiiter Link', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-twitter'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_instagram',
				'type'   => 'text',
				'label'  => esc_html__( 'Instagram Link', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-instagram'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_tripadvisor',
				'type'   => 'text',
				'label'  => esc_html__( 'Tripadvisor Link', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-tripadvisor'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_youtube',
				'type'   => 'text',
				'label'  => esc_html__( 'YouTube Link', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-youtube'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_google_plus',
				'type'   => 'text',
				'label'  => esc_html__( 'Google+ Link', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-google-plus'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_pinterest',
				'type'   => 'text',
				'label'  => esc_html__( 'Pinterest Link', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-pinterest'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_yelp',
				'type'   => 'text',
				'label'  => esc_html__( 'Yelp Link', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-yelp'
				)
			)
		);
		
		// Location front-end section - end
		
		// Amenity front-end section - begin
		
		$amenity_meta = urbango_listing_get_cpt_taxonomy_items( 'amenity', false );
		$amenities    = ! empty( $amenity_meta ) ? $amenity_meta : array();
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_amenity_section',
				'title'  => esc_html__( 'Amenity Section', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-amenity-section',
					'icon_class'   => 'far fa-check-square'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'        => 'listing_single_included_amenities',
				'type'        => 'checkboxgroup',
				'value'       => '',
				'label'       => esc_html__( 'Included Amenities', 'urbango-listing' ),
				'description' => esc_html__( 'Define included amenities for listing single page', 'urbango-listing' ),
				'options'     => $amenities,
				'parent'      => $add_listing_form,
				'args'        => array(
					'custom_class' => 'edgtf-listing-included-amenity edgtf-dashboard-field-full-width'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'        => 'listing_single_excluded_amenities',
				'type'        => 'checkboxgroup',
				'value'       => '',
				'label'       => esc_html__( 'Excluded Amenities', 'urbango-listing' ),
				'description' => esc_html__( 'Define excluded amenities for listing single page', 'urbango-listing' ),
				'options'     => $amenities,
				'parent'      => $add_listing_form,
				'args'        => array(
					'custom_class' => 'edgtf-listing-excluded-amenity edgtf-dashboard-field-full-width'
				)
			)
		);
		
		// Amenity front-end section - end
		
		// Open Table front-end section - begin
		
		if ( urbango_listing_check_is_listing_open_table_allowed() ) {
			
			urbango_edge_add_dashboard_section_title(
				array(
					'name'   => 'add_listing_open_table_section',
					'title'  => esc_html__( 'Open Table Section', 'urbango-listing' ),
					'parent' => $add_listing_form,
					'args'   => array(
						'custom_class' => 'edgtf-open-table-section',
						'icon_class'   => 'far fa-calendar-check'
					)
				)
			);
			
			urbango_edge_add_dashboard_field(
				array(
					'name'        => 'listing_single_open_table_id',
					'type'        => 'text',
					'label'       => esc_html__( 'Open Table ID', 'urbango-listing' ),
					'description' => esc_html__( 'Add your OpenTable ID for the listing single page', 'urbango-listing' ),
					'parent'      => $add_listing_form,
					'args'        => array(
						'custom_class' => 'edgtf-listing-open-table-id'
					)
				)
			);
		}
		
		// Open Table front-end section - end
		
		// Reviews Criteria front-end section - begin
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_reviews_criteria_section',
				'title'  => esc_html__( 'Reviews Criteria Section', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-reviews-criteria-section',
					'icon_class'   => 'far fa-star'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'        => 'listing_single_reviews',
				'type'        => 'select',
				'label'       => esc_html__( 'Show Reviews', 'urbango-listing' ),
				'description' => esc_html__( 'Enabling this option will show reviews on your listing single page', 'urbango-listing' ),
				'options'     => urbango_edge_get_yes_no_select_array(),
				'parent'      => $add_listing_form,
				'args'        => array(
					'select2'      => true,
					'custom_class' => 'edgtf-listing-reviews'
				)
			)
		);
		
		$reviews_criteria = urbango_listing_get_cpt_taxonomy_items( 'reviews-criteria' );
		
		if ( ! empty( $reviews_criteria ) ) {
			
			urbango_edge_add_dashboard_field(
				array(
					'name'        => 'listing_single_advanced_reviews',
					'type'        => 'select',
					'label'       => esc_html__( 'Enable Advanced Reviews', 'urbango-listing' ),
					'description' => esc_html__( 'Enabling this option will show advanced reviews criteria in reviews on your listing single page', 'urbango-listing' ),
					'options'     => urbango_edge_get_yes_no_select_array(),
					'parent'      => $add_listing_form,
					'args'        => array(
						'select2'      => true,
						'custom_class' => 'edgtf-listing-advanced-reviews'
					)
				)
			);
		}
		
		// Reviews Criteria front-end section - end
		
		// Business Hours front-end section - begin
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_business_hours_section',
				'title'  => esc_html__( 'Business Hours Section', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-business-hours-section',
					'icon_class'   => 'far fa-clock'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'        => 'listing_single_business_hours_time_zone',
				'type'        => 'select',
				'label'       => esc_html__( 'Date Time Zone', 'urbango-listing' ),
				'description' => esc_html__( 'Choose your time zone for setting your business hours time', 'urbango-listing' ),
				'options'     => urbango_listing_get_date_time_zone(),
				'parent'      => $add_listing_form,
				'args'        => array(
					'select2'      => true,
					'custom_class' => 'edgtf-listing-business-hours-time-zone'
				)
			)
		);
		
		urbango_edge_add_dashboard_repeater_field(
			array(
				'name'         => 'listing_single_business_hours',
				'button_text'  => '',
				'parent'       => $add_listing_form,
				'table_layout' => true,
				'fields'       => array(
					array(
						'name'      => 'day',
						'type'      => 'select',
						'label'     => esc_html__( 'Day', 'urbango-listing' ),
						'th'        => esc_html__( 'Day', 'urbango-listing' ),
						'options'   => urbango_listing_get_weekend_days(),
						'col_width' => '4',
						'args'      => array(
							'select2' => true
						)
					),
					array(
						'name'      => 'open_time',
						'type'      => 'select',
						'label'     => esc_html__( 'Open Time', 'urbango-listing' ),
						'th'        => esc_html__( 'Open Time', 'urbango-listing' ),
						'options'   => urbango_listing_get_hours_range(),
						'col_width' => '2',
						'args'      => array(
							'select2' => true
						)
					),
					array(
						'name'      => 'end_time',
						'type'      => 'select',
						'label'     => esc_html__( 'End Time', 'urbango-listing' ),
						'th'        => esc_html__( 'End Time', 'urbango-listing' ),
						'options'   => urbango_listing_get_hours_range(),
						'col_width' => '2',
						'args'      => array(
							'select2' => true
						)
					),
					array(
						'name'      => '24h_open',
						'type'      => 'select',
						'label'     => esc_html__( '24 Hours', 'urbango-listing' ),
						'th'        => esc_html__( '24 Hours', 'urbango-listing' ),
						'options'   => urbango_edge_get_yes_no_select_array( false ),
						'col_width' => '2',
						'args'      => array(
							'select2' => true
						)
					),
					array(
						'name'      => 'closed',
						'type'      => 'select',
						'label'     => esc_html__( 'Closed', 'urbango-listing' ),
						'th'        => esc_html__( 'Closed', 'urbango-listing' ),
						'options'   => urbango_edge_get_yes_no_select_array( false ),
						'col_width' => '2',
						'args'      => array(
							'select2' => true
						)
					)
				)
			)
		);
		
		// Business Hours front-end section - end
		
		// Additional Info front-end section - begin
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_additional_info_section',
				'title'  => esc_html__( 'Additional Info Section', 'urbango-listing' ),
				'parent' => $add_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-additional-info-section',
					'icon_class'   => 'far fa-plus-square'
				)
			)
		);
		
		urbango_edge_add_dashboard_repeater_field(
			array(
				'name'         => 'edgtf_listing_single_additional_info_meta',
				'button_text'  => '',
				'parent'       => $add_listing_form,
				'table_layout' => true,
				'fields'       => array(
					array(
						'name'      => 'label',
						'type'      => 'text',
						'label'     => esc_html__( 'Label', 'urbango-listing' ),
						'th'        => esc_html__( 'Label', 'urbango-listing' ),
						'col_width' => '4'
					),
					array(
						'name'      => 'value',
						'type'      => 'text',
						'label'     => esc_html__( 'Value', 'urbango-listing' ),
						'th'        => esc_html__( 'Value', 'urbango-listing' ),
						'col_width' => '4'
					),
					array(
						'name'      => 'value_link',
						'type'      => 'text',
						'label'     => esc_html__( 'Value Link', 'urbango-listing' ),
						'th'        => esc_html__( 'Value Link', 'urbango-listing' ),
						'col_width' => '4'
					)
				)
			)
		);
		
		// Additional Info front-end section - end
		
		// Hidden input fields front-end section - begin
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'listing_package',
				'parent' => $add_listing_form,
				'value'  => urbango_listing_get_user_current_package(),
				'args'   => array(
					'custom_class' => 'edgtf-dashboard-field-full-width',
					'input_type'   => 'hidden'
				)
			)
		);
		
		// Hidden input fields front-end section - end
		
		$add_listing->render();
	}
}

//fallback if someone enters page directly and has no packages

$package = urbango_listing_check_is_package_available();

//strongly false because of the 0 key for packages
if ( $package === false ) { ?>
	<div class="edgtf-no-package">
		<h3><?php esc_html_e( 'Please buy package in order to add more listings.', 'urbango-listing' ); ?></h3>
		<?php if ( urbango_listing_is_core_plugin_installed() ) {
			echo urbango_edge_get_button_html( array(
				'text' => esc_html__( 'Buy Packages', 'urbango-listing' ),
				'link' => urbango_listing_get_pricing_packages_page()
			) );
		} ?>
	</div>
<?php } else { ?>
	<div class="edgtf-listing-profile-add-listing">
		<div class="edgtf-lp-section-title">
			<h3 class="edgtf-lp-st-title"><?php esc_html_e( 'Add New Listing', 'urbango-listing' ); ?></h3>
			<p class="edgtf-lp-st-text"><?php esc_html_e( 'You can create new listings by filling out the fields below. Please note that fields marked with an asterisk (*) have to be filled before you can create your listing.', 'urbango-listing' ); ?></p>
		</div>
		<div>
			<?php urbango_listing_dashboard_add_listing_fields( $params ); ?>
			<?php do_action( 'urbango_membership_action_login_ajax_response' ); ?>
		</div>
	</div>
<?php } ?>