(function ($) {
	'use strict';
	
	var listingProfile = {};
	edgtf.modules.listingProfile = listingProfile;
	
	listingProfile.edgtfOnDocumentReady = edgtfOnDocumentReady;
	
	$(document).ready(edgtfOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		edgtfInitSavedSearchesRemove();
	}
	
	function edgtfInitSavedSearchesRemove() {
		var searchesTab = $('.edgtf-listing-profile-searches');
		
		if (searchesTab.length) {
			var removeQueryButton = searchesTab.find('.edgtf-undo-query-save');
			
			removeQueryButton.on('click', function (e) {
				e.preventDefault();
				
				var thisButton = $(this);
				
				if (!confirm('Are you sure you want to remove this search?')) {
					return;
				}
				
				thisButton.html('<span class="fa fa-spinner fa-spin" aria-hidden="true"></span>');
				
				var ajaxData = {
					action: 'urbango_listing_set_listing_list_ajax_remove_query',
					query_id: thisButton.data('query-id')
				};
				
				$.ajax({
					type: 'POST',
					data: ajaxData,
					url: edgtfGlobalVars.vars.edgtfAjaxUrl,
					success: function (data) {
						var response = JSON.parse(data);
						
						if (response.status === 'success') {
							thisButton.parents('.edgtf-lp-ss-content-row').remove();
						} else {
							thisButton.html('<i class="fa fa-times" aria-hidden="true"></i>');
						}
					}
				});
			});
		}
	}
	
})(jQuery);