<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_listing_cpt_classes' ) ) {
	/**
	 * Adds listing cpt classes to the body
	 *
	 * @param $classes
	 *
	 * @return array
	 */
	function urbango_listing_add_listing_cpt_classes( $classes ) {
		
		if ( ( is_archive() && get_post_type() === 'listing-item' ) || is_author() ) {
			$classes[] = 'urbango-listing-archive';
		}
		
		return $classes;
	}
	
	add_filter( 'body_class', 'urbango_listing_add_listing_cpt_classes' );
}

if ( ! function_exists( 'urbango_listing_allow_listing_cpt_for_meta_box_functions' ) ) {
	function urbango_listing_allow_listing_cpt_for_meta_box_functions( $post_types ) {
		$post_types[] = 'listing-item';
		
		return $post_types;
	}
	
	add_filter( 'urbango_edge_filter_meta_box_post_types_save', 'urbango_listing_allow_listing_cpt_for_meta_box_functions' );
	add_filter( 'urbango_edge_filter_meta_box_post_types_remove', 'urbango_listing_allow_listing_cpt_for_meta_box_functions' );
	
	// Allow reviews for custom post type
	add_filter( 'urbango_core_filter_rating_post_types', 'urbango_listing_allow_listing_cpt_for_meta_box_functions' );
	
	// Allow enquiry for custom post type
	add_filter( 'urbango_listing_filter_allowed_enquiry_pages', 'urbango_listing_allow_listing_cpt_for_meta_box_functions' );
	
	// Allow reports for custom post type
	add_filter( 'urbango_listing_filter_allowed_report_pages', 'urbango_listing_allow_listing_cpt_for_meta_box_functions' );
	
	// Allow claims for custom post type
	add_filter( 'urbango_listing_filter_allowed_claim_pages', 'urbango_listing_allow_listing_cpt_for_meta_box_functions' );
}

if ( ! function_exists( 'urbango_listing_add_listing_cpt_for_search_types' ) ) {
	function urbango_listing_add_listing_cpt_for_search_types( $post_types ) {
		$post_types['listing-item'] = esc_html__( 'Listing Item', 'urbango-listing' );
		
		return $post_types;
	}
	
	add_filter( 'urbango_edge_filter_search_post_type_widget_params_post_type', 'urbango_listing_add_listing_cpt_for_search_types' );
}

if ( ! function_exists( 'urbango_listing_allow_theme_meta_boxes_for_listing_cpt' ) ) {
	function urbango_listing_allow_theme_meta_boxes_for_listing_cpt( $post_types, $meta_box ) {
		
		if ( $meta_box === 'footer_meta' || $meta_box === 'header_meta' ) {
			$post_types[] = 'listing-item';
		}
		
		return $post_types;
	}
	
	add_filter( 'urbango_edge_filter_set_scope_for_meta_boxes', 'urbango_listing_allow_theme_meta_boxes_for_listing_cpt', 10, 2 );
}

if ( ! function_exists( 'urbango_listing_register_listing_custom_post_types' ) ) {
	function urbango_listing_register_listing_custom_post_types( $cpt_classes ) {
		$cpt_class = array(
			'UrbanGoListing\CPT\Listing\ListingRegister'
		);
		
		return array_merge( $cpt_classes, $cpt_class );
	}
	
	add_filter( 'urbango_listing_filter_register_custom_post_types', 'urbango_listing_register_listing_custom_post_types' );
}

if ( ! function_exists( 'urbango_listing_include_listing_shortcodes_files' ) ) {
	/**
	 * Loads all shortcodes by going through all folders that are placed directly in shortcodes folder
	 */
	function urbango_listing_include_listing_shortcodes_files() {
		foreach ( glob( URBANGO_LISTING_CPT_PATH . '/listing/shortcodes/*/load.php' ) as $shortcode_load ) {
			include_once $shortcode_load;
		}
	}
	
	add_action( 'urbango_listing_action_include_shortcodes_file', 'urbango_listing_include_listing_shortcodes_files' );
}

if ( ! function_exists( 'urbango_listing_get_archive_listing_item_content' ) ) {
	function urbango_listing_get_archive_listing_item_content( $urbango_taxonomy_id = '', $urbango_taxonomy_name = '', $urbango_author_id = '', $search_page_params = array() ) {
		$global_archive_options = array(
			'item_layout'                 => 'standard',
			'number_of_columns'           => 'three',
			'space_between_items'         => 'normal',
			'number_of_items'             => '12',
			'order_by'                    => 'featured-first',
			'custom_search'               => '',
			'category'                    => '',
			'location'                    => '',
			'tag'                         => '',
			'amenity'                     => '',
			'author_id'                   => '',
			'image_proportions'           => 'full',
			'title_tag'                   => 'h5',
			'enable_excerpt'              => 'yes',
			'excerpt_length'              => '',
			'enable_category'             => 'yes',
			'enable_location'             => 'yes',
			'enable_reviews_count'        => 'yes',
			'enable_price_range'          => 'yes',
			'enable_map'                  => 'yes',
			'enable_map_switcher'         => 'yes',
			'enable_filter'               => 'yes',
			'enable_filter_custom_search' => 'yes',
			'enable_filter_category'      => 'yes',
			'enable_filter_location'      => 'yes',
			'filter_location_field_type'  => 'places',
			'enable_filter_tag'           => 'yes',
			'enable_filter_order_by'      => 'yes',
			'enable_filter_switch_layout' => 'yes',
			'pagination_type'             => 'load-more'
		);
		
		$shortcode_params = array();
		foreach ( $global_archive_options as $key => $value ) {
			$global_option_value = urbango_edge_options()->getOptionValue( 'listing_archive_' . $key );
			$option_value        = ! empty( $global_option_value ) ? $global_option_value : $value;
			
			$shortcode_params[ $key ] = $option_value;
		}
		
		if ( ! empty( $search_page_params ) && is_array( $search_page_params ) ) {
			foreach ( $search_page_params as $key => $value ) {
				$shortcode_params[ $key ] = $value;
			}
		} else {
			$shortcode_params['category'] = $urbango_taxonomy_name === 'listing-category' && ! empty( $urbango_taxonomy_id ) ? $urbango_taxonomy_id : '';
			$shortcode_params['location'] = $urbango_taxonomy_name === 'listing-location' && ! empty( $urbango_taxonomy_id ) ? $urbango_taxonomy_id : '';
			$shortcode_params['tag']      = $urbango_taxonomy_name === 'listing-tag' && ! empty( $urbango_taxonomy_id ) ? $urbango_taxonomy_id : '';
			$shortcode_params['amenity']  = $urbango_taxonomy_name === 'listing-amenity' && ! empty( $urbango_taxonomy_id ) ? $urbango_taxonomy_id : '';
			
			if ( ! empty( $urbango_author_id ) ) {
				$shortcode_params['author_id']           = $urbango_author_id;
				$shortcode_params['enable_map']          = 'yes';
				$shortcode_params['enable_map_switcher'] = 'no';
				$shortcode_params['enable_filter']       = 'no';
			}
		}
		
		echo urbango_edge_execute_shortcode( 'edgtf_listing_list', apply_filters( 'urbango_listing_filter_listing_list_archive_params', $shortcode_params ) );
	}
}

if ( ! function_exists( 'urbango_listing_check_is_listing_open_table_allowed' ) ) {
	/**
	 * Function that check is open table feature enabled
	 *
	 * @return bool
	 */
	function urbango_listing_check_is_listing_open_table_allowed() {
		$open_table_enabled    = urbango_edge_options()->getOptionValue( 'listing_single_enable_open_table' ) === 'yes';
		$is_open_table_allowed = urbango_edge_core_plugin_installed() && $open_table_enabled;
		
		return $is_open_table_allowed;
	}
}

if ( ! function_exists( 'urbango_listing_check_is_listing_reviews_allowed' ) ) {
	/**
	 * Function that check is reviews feature enabled
	 *
	 * @param $additional_conditional string
	 *
	 * @return bool
	 */
	function urbango_listing_check_is_listing_reviews_allowed( $additional_conditional = '' ) {
		$reviews_enabled          = urbango_edge_get_meta_field_intersect( 'listing_single_reviews' ) === 'yes';
		$advanced_reviews_enabled = urbango_edge_get_meta_field_intersect( 'listing_single_advanced_reviews' ) === 'yes';
		
		if ( urbango_edge_core_plugin_installed() ) {
			if ( $additional_conditional === 'simple_and_advance' ) {
				$is_reviews_allowed = $reviews_enabled && $advanced_reviews_enabled;
			} else if ( $additional_conditional === 'only_advance' ) {
				$is_reviews_allowed = $advanced_reviews_enabled;
			} else {
				$is_reviews_allowed = $reviews_enabled;
			}
		} else {
			$is_reviews_allowed = false;
		}
		
		return $is_reviews_allowed;
	}
}

if ( ! function_exists( 'urbango_listing_enable_reviews_by_criteria_for_single_page' ) ) {
	function urbango_listing_enable_reviews_by_criteria_for_single_page( $default_criteria ) {
		$reviews_criteria = array();
		
		if ( urbango_listing_check_is_listing_reviews_allowed( 'simple_and_advance' ) ) {
			$reviews_criteria = urbango_core_taxonomy_rating_array( 'listing-reviews-criteria' );
		}
		
		return array_merge( $default_criteria, $reviews_criteria );
	}
	
	add_filter( 'urbango_core_filter_rating_criteria', 'urbango_listing_enable_reviews_by_criteria_for_single_page' );
}
