<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_listing_options_map' ) ) {
	function urbango_listing_add_listing_options_map() {
		
		$panel_slug = '_listing';
		
		urbango_edge_add_admin_page(
			array(
				'slug'  => $panel_slug,
				'title' => esc_html__( 'Listing', 'urbango-listing' ),
				'icon'  => 'fa fa-list-alt'
			)
		);
		
		// Additional before options - begin
		
		do_action( 'urbango_listing_action_additional_listing_before_options_map', $panel_slug );
		
		// Additional before options - end
		
		// Archive list options - begin
		
		$panel_listing_archive = urbango_edge_add_admin_panel(
			array(
				'name'  => 'panel_listing_archive',
				'title' => esc_html__( 'Archive', 'urbango-listing' ),
				'page'  => '_listing'
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_archive_layout_section',
				'title'  => esc_html__( 'Layout Section', 'urbango-listing' ),
				'parent' => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_item_layout',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Item Layout', 'urbango-listing' ),
				'options'       => array(
					''         => esc_html__( 'Default', 'urbango-listing' ),
					'standard' => esc_html__( 'Standard', 'urbango-listing' ),
					'simple'   => esc_html__( 'Simple', 'urbango-listing' )
				),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_number_of_columns',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Number of Columns', 'urbango-listing' ),
				'description'   => esc_html__( 'Set number of columns for your list. Default value is three', 'urbango-listing' ),
				'options'       => urbango_edge_get_number_of_columns_array( true ),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_space_between_items',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Space Between Items', 'urbango-listing' ),
				'description'   => esc_html__( 'Set space size between items for your list. Default value is normal', 'urbango-listing' ),
				'options'       => urbango_edge_get_space_between_items_array( true ),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'        => 'listing_archive_number_of_items',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Items', 'urbango-listing' ),
				'description' => esc_html__( 'Set number of items for your list. Enter -1 to show all.', 'urbango-listing' ),
				'parent'      => $panel_listing_archive,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_image_proportions',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Image Proportions', 'urbango-listing' ),
				'description'   => esc_html__( 'Set image proportions for your list. Default value is full', 'urbango-listing' ),
				'options'       => array(
					''          => esc_html__( 'Default', 'urbango-listing' ),
					'full'      => esc_html__( 'Original', 'urbango-listing' ),
					'landscape' => esc_html__( 'Landscape', 'urbango-listing' ),
					'portrait'  => esc_html__( 'Portrait', 'urbango-listing' ),
					'square'    => esc_html__( 'Square', 'urbango-listing' ),
					'thumbnail' => esc_html__( 'Thumbnail', 'urbango-listing' ),
					'medium'    => esc_html__( 'Medium', 'urbango-listing' ),
					'large'     => esc_html__( 'Large', 'urbango-listing' )
				),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_title_tag',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Title Tag', 'urbango-listing' ),
				'options'       => urbango_edge_get_title_tag( true, array( 'p' => 'p' ) ),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_excerpt',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Excerpt', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'        => 'listing_archive_excerpt_length',
				'type'        => 'text',
				'label'       => esc_html__( 'Excerpt Length', 'urbango-listing' ),
				'description' => esc_html__( 'Set number of characters', 'urbango-listing' ),
				'parent'      => $panel_listing_archive,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_category',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Category', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_location',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Location', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_reviews_count',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Overall Rating', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_price_range',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Price Range', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_archive_map_section',
				'title'  => esc_html__( 'Map Section', 'urbango-listing' ),
				'parent' => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_map',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Map', 'urbango-listing' ),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_map_switcher',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Map Switcher', 'urbango-listing' ),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_archive_filter_section',
				'title'  => esc_html__( 'Filter Section', 'urbango-listing' ),
				'parent' => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_filter',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Filter', 'urbango-listing' ),
				'parent'        => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_filter_custom_search',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Filter - Custom Search', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive,
				'dependency'    => array(
					'show' => array(
						'listing_archive_enable_filter' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_filter_category',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Filter - Category', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive,
				'dependency'    => array(
					'show' => array(
						'listing_archive_enable_filter' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_filter_location',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Filter - Location', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive,
				'dependency'    => array(
					'show' => array(
						'listing_archive_enable_filter' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_filter_location_field_type',
				'type'          => 'select',
				'default_value' => 'places',
				'label'         => esc_html__( 'Filter Location Field Type', 'urbango-listing' ),
				'options'       => array(
					'places' => esc_html__( 'AutoComplete Locations', 'urbango-listing' ),
					'select' => esc_html__( 'Select Box', 'urbango-listing' )
				),
				'parent'        => $panel_listing_archive,
				'dependency'    => array(
					'show' => array(
						'listing_archive_enable_filter_location' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_filter_tag',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Filter - Tag', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive,
				'dependency'    => array(
					'show' => array(
						'listing_archive_enable_filter' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_filter_order_by',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Filter - Order By', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive,
				'dependency'    => array(
					'show' => array(
						'listing_archive_enable_filter' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_enable_filter_switch_layout',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Filter - Switch Layout', 'urbango-listing' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $panel_listing_archive,
				'dependency'    => array(
					'show' => array(
						'listing_archive_enable_filter' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_archive_pagination_section',
				'title'  => esc_html__( 'Pagination Section', 'urbango-listing' ),
				'parent' => $panel_listing_archive
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_archive_pagination_type',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Pagination Type', 'urbango-listing' ),
				'options'       => array(
					''                => esc_html__( 'Default', 'urbango-listing' ),
					'no-pagination'   => esc_html__( 'None', 'urbango-listing' ),
					'standard'        => esc_html__( 'Standard', 'urbango-listing' ),
					'load-more'       => esc_html__( 'Load More', 'urbango-listing' ),
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'urbango-listing' )
				),
				'parent'        => $panel_listing_archive
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_archive_options_map', $panel_listing_archive );
		
		// Archive list options - end
		
		// Single page options - begin
		
		$panel_listing_single = urbango_edge_add_admin_panel(
			array(
				'name'  => 'panel_listing_single',
				'title' => esc_html__( 'Listing Single', 'urbango-listing' ),
				'page'  => '_listing'
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_single_general_section',
				'title'  => esc_html__( 'General Section', 'urbango-listing' ),
				'parent' => $panel_listing_single
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'        => 'listing_single_slug',
				'type'        => 'text',
				'label'       => esc_html__( 'Listing Single Slug', 'urbango-listing' ),
				'description' => esc_html__( 'Enter if you wish to use a different listing single slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect)', 'urbango-listing' ),
				'parent'      => $panel_listing_single,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_single_title_tag',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Title Tag', 'urbango-listing' ),
				'options'       => urbango_edge_get_title_tag( true ),
				'parent'        => $panel_listing_single
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_single_show_only_parent_category',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show Only Parent Category', 'urbango-listing' ),
				'description'   => esc_html__( 'Enabling this option will show only parent categories info on your listing single page', 'urbango-listing' ),
				'parent'        => $panel_listing_single
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_single_open_table_section',
				'title'  => esc_html__( 'Open Table Section', 'urbango-listing' ),
				'parent' => $panel_listing_single
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_single_enable_open_table',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Open Table', 'urbango-listing' ),
				'description'   => esc_html__( 'Enabling this option will show open table form on your listing single page', 'urbango-listing' ),
				'parent'        => $panel_listing_single
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_single_reviews_section',
				'title'  => esc_html__( 'Reviews Section', 'urbango-listing' ),
				'parent' => $panel_listing_single
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_single_reviews',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Reviews', 'urbango-listing' ),
				'description'   => esc_html__( 'Enabling this option will show reviews on your listing single page', 'urbango-listing' ),
				'parent'        => $panel_listing_single
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_single_advanced_reviews',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Advanced Reviews', 'urbango-listing' ),
				'description'   => esc_html__( 'Enabling this option will show advanced reviews criteria in reviews on your listing single page', 'urbango-listing' ),
				'parent'        => $panel_listing_single,
				'dependency'    => array(
					'show' => array(
						'listing_single_reviews' => 'yes'
					)
				)
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_single_options_map', $panel_listing_single );
		
		// Single page options - end
		
		// Additional options - begin
		
		do_action( 'urbango_listing_action_additional_listing_options_map', $panel_slug );
		
		// Additional options - end
		
	}
	
	add_action( 'urbango_edge_action_options_map', 'urbango_listing_add_listing_options_map', urbango_edge_set_options_map_position( 'listing' ) );
}
