<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_listing_taxonomy_meta_boxes' ) ) {
	function urbango_listing_add_listing_taxonomy_meta_boxes() {
		
		// Category taxonomy meta box section - begin
		
		$category_box = urbango_edge_add_taxonomy_fields(
			array(
				'scope' => 'listing-category',
				'name'  => 'listing_category_taxonomy_meta_box'
			)
		);
		
		urbango_edge_add_taxonomy_field(
			array(
				'name'        => 'edgtf_listing_category_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Category Featured Image', 'urbango-listing' ),
				'description' => esc_html__( 'Choose your category featured image', 'urbango-listing' ),
				'parent'      => $category_box
			)
		);
		
		urbango_edge_add_taxonomy_field(
			array(
				'name'        => 'edgtf_listing_category_icon_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Category Icon', 'urbango-listing' ),
				'description' => esc_html__( 'Choose your category custom icon', 'urbango-listing' ),
				'parent'      => $category_box
			)
		);
		
		urbango_edge_add_taxonomy_field(
			array(
				'name'        => 'edgtf_listing_category_svg_icon_meta',
				'type'        => 'textarea',
				'label'       => esc_html__( 'Category SVG Icon', 'urbango-listing' ),
				'description' => esc_html__( 'Fill your category svg icon path in order to show different icon for your listings', 'urbango-listing' ),
				'parent'      => $category_box
			)
		);
		
		urbango_edge_add_taxonomy_field(
			array(
				'name'        => 'edgtf_listing_category_search_icon_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Category Search Icon', 'urbango-listing' ),
				'description' => esc_html__( 'Choose your category custom icon for listing search shortcode', 'urbango-listing' ),
				'parent'      => $category_box
			)
		);
		
		$tags = urbango_listing_get_cpt_taxonomy_items( 'tag', false );
		
		if ( ! empty( $tags ) ) {
			
			urbango_edge_add_taxonomy_field(
				array(
					'name'        => 'edgtf_listing_category_relation_tags_meta',
					'type'        => 'checkboxgroup',
					'label'       => esc_html__( 'Category Relation Tags', 'urbango-listing' ),
					'description' => esc_html__( 'Define relation tags for this category', 'urbango-listing' ),
					'options'     => $tags,
					'parent'      => $category_box
				)
			);
		}
		
		urbango_edge_add_taxonomy_field(
			array(
				'name'        => 'edgtf_listing_category_order_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Menu Order', 'urbango-listing' ),
				'description' => esc_html__( 'Set your order and categories will be displayed in that order if Menu Order value is set for the shortcode Order By option', 'urbango-listing' ),
				'parent'      => $category_box
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_taxonomy_category_meta_boxes', $category_box );
		
		// Category taxonomy meta box section - begin
		
		// Location taxonomy meta box section - begin
		
		$location_box = urbango_edge_add_taxonomy_fields(
			array(
				'scope' => 'listing-location',
				'name'  => 'listing_location_taxonomy_meta_box'
			)
		);
		
		urbango_edge_add_taxonomy_field(
			array(
				'name'        => 'edgtf_listing_location_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Location Featured Image', 'urbango-listing' ),
				'description' => esc_html__( 'Choose your location featured image', 'urbango-listing' ),
				'parent'      => $location_box
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_taxonomy_location_meta_boxes', $location_box );
		
		// Location taxonomy meta box section - begin
		
		// Reviews Criteria taxonomy meta box section - begin
		
		$reviews_criteria_box = urbango_edge_add_taxonomy_fields(
			array(
				'scope' => 'listing-reviews-criteria',
				'name'  => 'listing_reviews_criteria_taxonomy_meta_box'
			)
		);
		
		urbango_edge_add_taxonomy_field(
			array(
				'name'        => 'listing_reviews_criteria_order',
				'type'        => 'text',
				'label'       => esc_html__( 'Order', 'urbango-listing' ),
				'description' => esc_html__( 'If there are multiple criteria, they will be displayed in an ascending order', 'urbango-listing' ),
				'parent'      => $reviews_criteria_box
			)
		);
		
		urbango_edge_add_taxonomy_field(
			array(
				'name'        => 'listing_reviews_criteria_show',
				'type'        => 'select',
				'label'       => esc_html__( 'Show in Reviews', 'urbango-listing' ),
				'description' => esc_html__( 'All the criteria can be rated when leaving a review, but only those marked to be shown will be displayed in the list of reviews', 'urbango-listing' ),
				'options'     => urbango_edge_get_yes_no_select_array( false, true ),
				'parent'      => $reviews_criteria_box
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_taxonomy_reviews_criteria_meta_boxes', $reviews_criteria_box );
		
		// Reviews Criteria taxonomy meta box section - begin
		
	}
	
	add_action( 'urbango_edge_action_custom_taxonomy_fields', 'urbango_listing_add_listing_taxonomy_meta_boxes' );
}
