<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

?>
<div class="edgtf-claim-form-holder">
    <div class="edgtf-claim-form-inner">
        <a class="edgtf-claim-close" href="#">
			<?php echo urbango_edge_icon_collections()->renderIcon( 'icon_close', 'font_elegant' ); ?>
        </a>
        <form class="edgtf-claim-form" data-id="" method="POST">
            <h5 class="edgtf-claim-title">
                <span class="edgtf-claim-title-label"><?php esc_html_e( 'Claim this Listing', 'urbango-listing' ); ?></span>
            </h5>
            <textarea name="edgtf_claim_message" id="edgtf-claim-message" placeholder="<?php esc_attr_e( 'Fill your message...', 'urbango-listing' ); ?>" required></textarea>

			<?php if ( urbango_listing_is_core_plugin_installed() ) {
				echo urbango_edge_get_button_html( array(
					'custom_class' => 'edgtf-claim-submit',
					'html_type'    => 'button',
					'text'         => esc_html__( 'Send Your Claim', 'urbango-listing' )
				) );
			} ?>

            <input type="hidden" id="edgtf-claim-user-id" value="<?php echo get_current_user_id(); ?>">

			<?php wp_nonce_field( 'urbango_listing_validate_listing_item_claim_form', 'urbango_listing_nonce_listing_item_claim_form' ); ?>
        </form>
        <div class="edgtf-claim-form-response"></div>
    </div>
</div>