<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

?>
<div class="edgtf-listing-profile-claimed-items">
	<?php if ( ! empty( $user_claimed_items ) ) { ?>
		<div class="edgtf-lp-section-title">
			<h3 class="edgtf-lp-st-title"><?php esc_html_e( 'Claimed Items', 'urbango-listing' ); ?></h3>
			<p class="edgtf-lp-st-text"><?php esc_html_e( 'The entire list of claimed items for which the users have left either positive or negative comments can be found below.', 'urbango-listing' ); ?></p>
		</div>
		<div class="edgtf-lp-claimed-items">
			<div class="edgtf-lp-ci-heading">
				<span class="edgtf-lp-ci-heading-listing"><?php esc_html_e( 'Listing', 'urbango-listing' ); ?></span>
				<span class="edgtf-lp-ci-heading-user"><?php esc_html_e( 'User', 'urbango-listing' ); ?></span>
				<span class="edgtf-lp-ci-heading-message"><?php esc_html_e( 'Message', 'urbango-listing' ); ?></span>
				<span class="edgtf-lp-ci-heading-date"><?php esc_html_e( 'Date', 'urbango-listing' ); ?></span>
			</div>
			<div class="edgtf-lp-ci-content">
				<?php foreach ( $user_claimed_items as $claim_id => $item_id ) {
					$user_id      = get_post_meta( $claim_id, 'edgtf_listing_claimed_user_id_meta', true );
					$user_message = get_post_meta( $claim_id, 'edgtf_listing_claimed_user_claimed_message_meta', true );
					
					if ( ! empty( $user_id ) && ! empty( $user_message ) ) { ?>
						<div class="edgtf-lp-ci-content-row">
							<h6 class="edgtf-lp-ci-listing-name">
								<a itemprop="url" href="<?php the_permalink( $item_id ); ?>"><?php echo get_the_title( $item_id ); ?></a>
							</h6>
							<p class="edgtf-lp-ci-user">
								<a itemprop="url" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID', $user_id ) ) ); ?>">
									<?php echo esc_html( get_the_author_meta( 'display_name', $user_id ) ); ?>
								</a>
							</p>
							<p class="edgtf-lp-ci-user-message"><?php echo esc_html( $user_message ); ?></p>
							<p class="edgtf-lp-ci-date"><?php echo get_the_time( get_option( 'date_format' ), $claim_id ); ?></p>
						</div>
					<?php }
				} ?>
			</div>
		</div>
	<?php } else { ?>
		<h3 class="edgtf-lp-not-found"><?php esc_html_e( 'You don\'t have any claimed items.', 'urbango-listing' ); ?></h3>
	<?php } ?>
</div>