<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_claimed_items_profile_navigation_item' ) ) {
	function urbango_listing_add_claimed_items_profile_navigation_item( $navigation, $dashboard_url ) {
		
		$navigation['claimed-items'] = array(
			'url'         => esc_url( add_query_arg( array( 'user-action' => 'claimed-items' ), $dashboard_url ) ),
			'text'        => esc_html__( 'Claimed', 'urbango-listing' ),
			'user_action' => 'claimed-items',
			'icon'        => 'claimed-items',
			'font_icon'   => array( 'icon_error-circle_alt', 'font_elegant' )
		);
		
		return $navigation;
	}
	
	add_filter( 'urbango_membership_dashboard_navigation_pages', 'urbango_listing_add_claimed_items_profile_navigation_item', 25, 2 );
}

if ( ! function_exists( 'urbango_listing_add_claimed_items_profile_navigation_pages' ) ) {
	function urbango_listing_add_claimed_items_profile_navigation_pages( $page, $action ) {
		
		if ( $action == 'claimed-items' ) {
			$params                       = array();
			$params['user_claimed_items'] = urbango_listing_get_user_claimed_items();
			$page                         = urbango_listing_get_module_template_part( 'cpt-claim-profile', 'claim', 'claimed-items', '', $params, array(), false );
		}
		
		return $page;
	}
	
	add_filter( 'urbango_membership_dashboard_pages', 'urbango_listing_add_claimed_items_profile_navigation_pages', 10, 2 );
}
