(function ($) {
	'use strict';
	
	var claim = {};
	edgtf.modules.claim = claim;
	
	claim.edgtfOnDocumentReady = edgtfOnDocumentReady;
	
	$(document).ready(edgtfOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		edgtfInitClaim();
	}
	
	/**
	 * Initializes claim functionality
	 */
	function edgtfInitClaim() {
		var claimOpener = $('.edgtf-claim-opener'),
			claimHolder = $('.edgtf-claim-form-holder');
		
		if (claimOpener.length) {
			
			if (claimHolder.length) {
				var claimForm = claimHolder.find('.edgtf-claim-form'),
					claimFormCloseButton = claimHolder.find('.edgtf-claim-close'),
					responseMessage = claimHolder.find('.edgtf-claim-form-response');
				
				claimFormCloseButton.on('click', function (e) {
					e.preventDefault();
					
					claimHolder.fadeOut(300).removeClass('edgtf-opened');
				});
				
				// Close form on esc key
				$(window).on('keyup', function (e) {
					if (claimHolder.hasClass('edgtf-opened') && e.keyCode === 27) {
						claimHolder.fadeOut(300).removeClass('edgtf-opened');
					}
				});
				
				claimForm.on('submit', function (e) {
					e.preventDefault();
					
					if (edgtf.body.hasClass('logged-in')) {
						responseMessage.empty().html('<span class="fa fa-spinner fa-spin" aria-hidden="true"></span>');
						
						var claimData = {
							message: claimForm.find('#edgtf-claim-message').val(),
							itemID: claimForm.data('id'),
							userID: claimForm.find('#edgtf-claim-user-id').val(),
							nonce: claimForm.find('#urbango_listing_nonce_listing_item_claim_form').val()
						};
						
						var requestData = {
							action: 'urbango_listing_send_listing_item_claim',
							claimData: claimData
						};
						
						$.ajax({
							type: "POST",
							url: edgtfGlobalVars.vars.edgtfAjaxUrl,
							data: requestData,
							success: function (data) {
								var response = JSON.parse(data);
								
								if (response.status === 'success') {
									responseMessage.html(response.message);
									
									setTimeout(function () {
										claimHolder.fadeOut(300).removeClass('edgtf-opened');
									}, 800);
								} else {
									responseMessage.html(response.message);
								}
							}
						});
					} else {
						// Trigger event.
						$(document.body).trigger('open_user_login_trigger');
					}
				});
			}
			
			claimOpener.each(function () {
				var thisClaimOpener = $(this),
					itemID = thisClaimOpener.data('id');
				
				thisClaimOpener.off().on('click', function (e) {
					e.preventDefault();
					
					if (edgtf.body.hasClass('logged-in')) {
						claimHolder.fadeIn(300).addClass('edgtf-opened');
						
						// Set default values
						claimForm.data('id', itemID).find('#edgtf-claim-message').val('');
						responseMessage.empty();
					} else {
						// Trigger event.
						$(document.body).trigger('open_user_login_trigger');
					}
				});
			});
		}
	}
	
})(jQuery);