<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_listing_claim_meta_boxes' ) ) {
	function urbango_listing_add_listing_claim_meta_boxes() {
		
		// Claim meta box section - begin
		
		$claim_box = urbango_edge_create_meta_box(
			array(
				'scope' => 'claim',
				'title' => esc_html__( 'Claim Section', 'urbango-listing' ),
				'name'  => 'listing_claim_meta_box'
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_claimed_item_info',
				'title'  => esc_html__( 'Claimed Item Information', 'urbango-listing' ),
				'parent' => $claim_box
			)
		);
		
		$listing_items = urbango_listing_get_cpt_items( 'listing-item' );
		
		if ( ! empty( $listing_items ) ) {
			
			urbango_edge_create_meta_box_field(
				array(
					'name'    => 'edgtf_listing_claimed_listing_item_id_meta',
					'type'    => 'select',
					'label'   => esc_html__( 'Claimed Listing Item', 'urbango-listing' ),
					'options' => $listing_items,
					'parent'  => $claim_box,
					'args'    => array(
						'select2' => true
					)
				)
			);
		}
		
		urbango_edge_create_meta_box_field(
			array(
				'name'    => 'edgtf_listing_claimed_user_id_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Claim by User', 'urbango-listing' ),
				'options' => urbango_listing_get_all_users( true ),
				'parent'  => $claim_box,
				'args'    => array(
					'select2' => true
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_listing_claimed_user_claimed_message_meta',
				'type'   => 'textarea',
				'label'  => esc_html__( 'Claimed Message', 'urbango-listing' ),
				'parent' => $claim_box,
			)
		);
		
		// Claim meta box section - end
		
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_listing_add_listing_claim_meta_boxes', 1 );
}
