<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( urbango_listing_check_is_ads_allowed() && urbango_listing_check_is_ads_allowed_for_user_current_package() ) {
	$page_id     = get_the_ID();
	$ads_id_meta = urbango_edge_options()->getOptionValue( 'listing_single_ads_id' );
	$ads_items   = urbango_listing_get_cpt_items( 'ads-item' );

	foreach ( $ads_items as $id => $title ) {
		$ads_id     = intval( $id );
		$listing_id = get_post_meta( $ads_id, 'edgtf_listing_ads_listing_item_id_meta', true );

		// Check if specific ads is set for this item, $listing_page_id params are forward throw template part and return current page id
		if ( intval( $listing_id ) === $listing_page_id ) {
			$ads_id_meta = $ads_id;
			break;
		}
	}

	if ( ! empty( $ads_id_meta ) ) {
		$title_meta     = get_post_meta( $ads_id_meta, 'edgtf_listing_ads_title_meta', true );
		$title_tag_meta = get_post_meta( $ads_id_meta, 'edgtf_listing_ads_title_tag_meta', true );
		$title_tag      = ! empty( $title_tag_meta ) ? $title_tag_meta : 'h6';
		$excerpt_meta   = get_post_meta( $ads_id_meta, 'edgtf_listing_ads_excerpt_meta', true );
		$image_meta     = get_post_meta( $ads_id_meta, 'edgtf_listing_ads_image_meta', true );
		$link_meta      = get_post_meta( $ads_id_meta, 'edgtf_listing_ads_link_meta', true );
		$link_html      = ! empty( $link_meta ) ? '<a itemprop="url" class="edgtf-ls-ads-link" href="' . esc_url( $link_meta ) . '">' : '';
		$link_html_end  = ! empty( $link_meta ) ? '</a>' : '';
		?>
        <div class="edgtf-ls-ads">
			<?php urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/parts-title', '', array( 'title' => esc_attr__( 'Sponsored Ad', 'urbango-listing' ) ) ); ?>

            <div class="edgtf-ls-ads-info">
				<?php if ( ! empty( $image_meta ) ) {
					if ( function_exists( 'urbango_edge_get_module_part' ) ) {
						echo urbango_edge_get_module_part( $link_html . wp_get_attachment_image( urbango_edge_get_attachment_id_from_url( $image_meta ), 'full' ) . $link_html_end );
					}
				} ?>
				<?php if ( ! empty( $title_meta ) ) { ?>
                <<?php echo esc_attr( $title_tag ); ?> class="edgtf-ls-ads-title">
				<?php
				if ( function_exists( 'urbango_edge_get_module_part' ) ) {
					echo urbango_edge_get_module_part( $link_html . esc_html( $title_meta ) . $link_html_end );
				}
				?>
            </<?php echo esc_attr( $title_tag ); ?>>
		<?php } ?>
			<?php if ( ! empty( $excerpt_meta ) ) { ?>
                <p class="edgtf-ls-ads-text"><?php echo esc_html( $excerpt_meta ); ?></p>
			<?php } ?>
        </div>
        </div>
	<?php }
} ?>