<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_allow_ads_cpt_for_meta_box_functions' ) ) {
	function urbango_listing_allow_ads_cpt_for_meta_box_functions( $post_types ) {
		$post_types[] = 'ads-item';
		
		return $post_types;
	}
	
	add_filter( 'urbango_edge_filter_meta_box_post_types_save', 'urbango_listing_allow_ads_cpt_for_meta_box_functions' );
	add_filter( 'urbango_edge_filter_meta_box_post_types_remove', 'urbango_listing_allow_ads_cpt_for_meta_box_functions' );
}

if ( ! function_exists( 'urbango_listing_register_ads_custom_post_types' ) ) {
	function urbango_listing_register_ads_custom_post_types( $cpt_classes ) {
		$cpt_class = array(
			'UrbanGoListing\CPT\Ads\AdsRegister'
		);
		
		return array_merge( $cpt_classes, $cpt_class );
	}
	
	add_filter( 'urbango_listing_filter_register_custom_post_types', 'urbango_listing_register_ads_custom_post_types' );
}

if ( ! function_exists( 'urbango_listing_check_is_ads_allowed' ) ) {
	/**
	 * Function that check is ads feature enabled
	 *
	 * @return bool
	 */
	function urbango_listing_check_is_ads_allowed() {
		$ads_enabled    = urbango_edge_options()->getOptionValue( 'enable_ads_feature' ) === 'yes';
		$is_ads_allowed = urbango_edge_core_plugin_installed() && $ads_enabled;
		
		return $is_ads_allowed;
	}
}
