<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_ads_options_map' ) ) {
	function urbango_listing_add_ads_options_map( $panel ) {
		
		$panel_ads = urbango_edge_add_admin_panel(
			array(
				'name'  => 'panel_ads',
				'title' => esc_html__( 'Ads', 'urbango-listing' ),
				'page'  => $panel
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'enable_ads_feature',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Ads for Listing Items', 'urbango-listing' ),
				'description'   => esc_html__( 'Enabling this option will show ads on listing single pages', 'urbango-listing' ),
				'parent'        => $panel_ads
			)
		);
		
		$enabled_ads_container = urbango_edge_add_admin_container(
			array(
				'name'       => 'enabled_ads_container',
				'parent'     => $panel_ads,
				'dependency' => array(
					'show' => array(
						'enable_ads_feature' => 'yes'
					)
				)
			)
		);
		
		$ads = urbango_listing_get_cpt_items( 'ads-item', array(), true );
		
		urbango_edge_add_admin_field(
			array(
				'name'        => 'listing_single_ads_id',
				'type'        => 'select',
				'label'       => esc_html__( 'Choose Ads', 'urbango-listing' ),
				'description' => esc_html__( 'Choose the ads that will be displayed on all listing single pages', 'urbango-listing' ),
				'options'     => $ads,
				'parent'      => $enabled_ads_container,
				'args'        => array(
					'select2' => true
				)
			)
		);
		
		// Additional options - begin
		
		do_action( 'urbango_listing_action_additional_ads_options_map', $panel_ads );
		
		// Additional options - end
		
	}
	
	add_action( 'urbango_listing_action_additional_listing_options_map', 'urbango_listing_add_ads_options_map' );
}
