<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_listing_ads_meta_boxes' ) ) {
	function urbango_listing_add_listing_ads_meta_boxes() {
		
		// Ads meta box section - begin
		
		$ads_box = urbango_edge_create_meta_box(
			array(
				'scope' => 'ads-item',
				'title' => esc_html__( 'Ads Section', 'urbango-listing' ),
				'name'  => 'listing_ads_meta_box'
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_ads_title_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Title', 'urbango-listing' ),
				'description' => esc_html__( 'Fill ads title for the listing single pages', 'urbango-listing' ),
				'parent'      => $ads_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_listing_ads_title_tag_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Title Tag', 'urbango-listing' ),
				'options'       => urbango_edge_get_title_tag( true ),
				'parent'        => $ads_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_ads_excerpt_meta',
				'type'        => 'textarea',
				'label'       => esc_html__( 'Excerpt', 'urbango-listing' ),
				'description' => esc_html__( 'Fill ads excerpt for the listing single pages', 'urbango-listing' ),
				'parent'      => $ads_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_ads_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Image', 'urbango-listing' ),
				'description' => esc_html__( 'Choose ads image for the listing single pages', 'urbango-listing' ),
				'parent'      => $ads_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_ads_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Custom Link', 'urbango-listing' ),
				'description' => esc_html__( 'Fill ads custom link for the listing single pages', 'urbango-listing' ),
				'parent'      => $ads_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		$listing_items = urbango_listing_get_cpt_items( 'listing-item', array(), true );
		
		if ( ! empty( $listing_items ) ) {
			
			urbango_edge_create_meta_box_field(
				array(
					'name'        => 'edgtf_listing_ads_listing_item_id_meta',
					'type'        => 'select',
					'label'       => esc_html__( 'Choose Listing Item', 'urbango-listing' ),
					'description' => esc_html__( 'Choose the listing item where you want to show this Ads. Leave empty if you want to show global ads you set in UrbanGo Options -> Listing -> Ads section', 'urbango-listing' ),
					'options'     => $listing_items,
					'parent'      => $ads_box,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
		
		// Ads meta box section - end
		
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_listing_add_listing_ads_meta_boxes', 1 );
}
