<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'UrbanGoListingWishlistDropdown' ) && class_exists( 'UrbanGoEdgeClassWidget' ) ) {
	class UrbanGoListingWishlistDropdown extends UrbanGoEdgeClassWidget {
		
		public function __construct() {
			parent::__construct(
				'edgtf_wishlist_dropdown',
				esc_html__( 'UrbanGo Wishlist Dropdown', 'urbango-listing' ),
				array( 'description' => esc_html__( 'Display a wishlist heart icon with a dropdown that shows all items you added in wishlist', 'urbango-listing' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'        => 'textfield',
					'name'        => 'widget_margin',
					'title'       => esc_html__( 'Margin', 'urbango-listing' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'urbango-listing' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			$styles = array();
			
			if ( $instance['widget_margin'] !== '' ) {
				$styles[] = 'margin: ' . $instance['widget_margin'];
			}
			
			$items           = urbango_listing_get_wishlist_items();
			$number_of_items = urbango_listing_get_number_of_wishlist_items();
			
			$classes = ! empty( $number_of_items ) ? 'edgtf-wd-has-items' : 'edgtf-wd-no-items';
			?>
			<div class="edgtf-wishlist-dropdown-holder <?php echo esc_attr( $classes ); ?>" <?php urbango_edge_inline_style( $styles ); ?>>
				<div class="edgtf-wd-inner">
					<a itemprop="url" href="#" class="edgtf-wd-link">
						<span class="edgtf-wd-link-inner">
							<?php echo urbango_edge_icon_collections()->renderIcon( 'far fa-heart', 'font_awesome', array( 'icon_attributes' => array( 'class' => 'edgtf-wd-icon' ) ) ); ?>
							<span class="edgtf-wd-number-of-items"><?php echo esc_html( $number_of_items ); ?></span>
						</span>
					</a>
					<div class="edgtf-wd-items-holder">
						<div class="edgtf-wd-items">
							<?php if ( ! empty( $number_of_items ) ) {
								foreach ( $items as $id => $title ) {
									$item_params          = array();
									$item_params['id']    = $id;
									$item_params['title'] = $title;
									
									urbango_listing_get_module_template_part( 'modules', 'wishlist', 'widgets/wishlist-dropdown/templates/wishlist-dropdown-item', '', $item_params );
								}
							} ?>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}
}
