(function ($) {
	'use strict';
	
	var wishlistDropdown = {};
	edgtf.modules.wishlist = wishlistDropdown;
	
	wishlistDropdown.edgtfOnDocumentReady = edgtfOnDocumentReady;
	
	$(document).ready(edgtfOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		edgtfInitWishlistDropdown();
	}
	
	/**
	 * Initializes wishlist dropdown functionality
	 */
	function edgtfInitWishlistDropdown() {
		var holder = $('.edgtf-wishlist-dropdown-holder');
		
		if (holder.length) {
			holder.each(function () {
				var thisHolder = $(this),
					link = thisHolder.find('.edgtf-wd-link'),
					numberOfItemsValue = link.find('.edgtf-wd-number-of-items'),
					itemsHolder = thisHolder.find('.edgtf-wd-items'),
					removeLink = itemsHolder.find('.edgtf-wd-remove-item');
				
				link.on('click', function (e) {
					e.preventDefault();
				});
				
				removeLink.off().on('click', function (e) {
					e.preventDefault();
					
					var thisRemoveLink = $(this),
						removeLinkHTML = thisRemoveLink.html(),
						removeItemID = thisRemoveLink.data('id');
					
					thisRemoveLink.html('<span class="fa fa-spinner fa-spin" aria-hidden="true"></span>');
					
					$.ajax({
						type: "POST",
						url: edgtfGlobalVars.vars.edgtfAjaxUrl,
						data: {
							action: 'urbango_listing_wishlist_ajax_functionality',
							wishlistData: {
								type: 'remove',
								itemID: removeItemID
							}
						},
						success: function (data) {
							var response = JSON.parse(data);
							
							if (response.status === 'success') {
								var newNumberOfItemsValue = parseInt(response.data['count'], 10);
						
								numberOfItemsValue.html(newNumberOfItemsValue);
								
								if (newNumberOfItemsValue === 0) {
									thisHolder.removeClass('edgtf-wd-has-items').addClass('edgtf-wd-no-items');
								}
								
								thisRemoveLink.closest('.edgtf-wd-item').fadeOut(200).remove();
								
								$(document).trigger('urbango_listing_wishlist_item_is_removed', [removeItemID]);
							} else {
								thisRemoveLink.html(removeLinkHTML);
							}
						}
					});
				});
			});
		}
	}
	
	$(document).on('urbango_listing_wishlist_item_is_added', function (e, addedItemID) {
		var holder = $('.edgtf-wishlist-dropdown-holder');
		
		if (holder.length) {
			holder.each(function () {
				var thisHolder = $(this),
					link = thisHolder.find('.edgtf-wd-link'),
					numberOfItemsValue = link.find('.edgtf-wd-number-of-items'),
					itemsHolder = thisHolder.find('.edgtf-wd-items');
				
				$.ajax({
					type: "POST",
					url: edgtfGlobalVars.vars.edgtfAjaxUrl,
					data: {
						action: 'urbango_listing_update_wishlist_dropdown_widget',
						wishlistData: {
							itemID: addedItemID
						}
					},
					success: function (data) {
						var response = JSON.parse(data);
						
						if (response.status === 'success') {
							numberOfItemsValue.html(parseInt(response.data['count'], 10));
							
							if (thisHolder.hasClass('edgtf-wd-no-items')) {
								thisHolder.removeClass('edgtf-wd-no-items').addClass('edgtf-wd-has-items');
							}
							
							itemsHolder.append(response.data['new_html']);
						}
					},
					complete: function () {
						edgtfInitWishlistDropdown();
					}
				});
			});
		}
	});
	
})(jQuery);