<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( is_user_logged_in() ) {
	$user_id   = get_current_user_id();
	$user_meta = get_user_meta( $user_id, 'edgtf_user_wishlist_items', true );
}

$wishlist_class = isset( $user_meta ) && isset( $user_meta[ get_the_ID() ] ) ? 'edgtf-added' : '';
$enable_title   = isset( $enable_title ) ? $enable_title : true;
?>
<div class="edgtf-wishlist-holder">
	<a class="edgtf-wishlist-link <?php echo esc_attr( $wishlist_class ); ?>" href="#" data-id="<?php the_ID(); ?>">
		<?php if ( $enable_title ) {
			$wishlist_title       = esc_html__( 'Add to wishlist', 'urbango-listing' );
			$wishlist_added_title = esc_html__( 'Added into wishlist', 'urbango-listing' );
			?>
			<span class="edgtf-wishlist-title" data-title="<?php echo esc_attr( $wishlist_title ); ?>" data-added-title="<?php echo esc_attr( $wishlist_added_title ); ?>"><?php echo ! empty( $wishlist_class ) ? $wishlist_added_title : $wishlist_title; ?></span>
		<?php } ?>
		<?php echo urbango_edge_icon_collections()->renderIcon( 'far fa-heart', 'font_awesome' ); ?>
	</a>
	<div class="edgtf-wishlist-response"></div>
</div>