<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_remove_administrator_role_caps' ) ) {
	function urbango_listing_remove_administrator_role_caps() {
		
		// Add the roles you'd like to administer the custom post types
		$roles = array( 'editor', 'administrator' );
		
		// Allowed custom post types
		$cpt_items = array( 'ads-item', 'package', 'report', 'claim' );
		
		// Loop through each role and remove capabilities
		foreach ( $roles as $the_role ) {
			$role = get_role( $the_role );
			
			foreach ( $cpt_items as $cpt ) {
				$role->remove_cap( 'read_' . $cpt );
				$role->remove_cap( 'read_private_' . $cpt . 's' );
				$role->remove_cap( 'edit_' . $cpt );
				$role->remove_cap( 'edit_' . $cpt . 's' );
				$role->remove_cap( 'edit_others_' . $cpt . 's' );
				$role->remove_cap( 'edit_published_' . $cpt . 's' );
				$role->remove_cap( 'publish_' . $cpt . 's' );
				$role->remove_cap( 'delete_' . $cpt );
				$role->remove_cap( 'delete_others_' . $cpt . 's' );
				$role->remove_cap( 'delete_private_' . $cpt . 's' );
				$role->remove_cap( 'delete_published_' . $cpt . 's' );
			}
		}
	}
	
	add_action( 'urbango_listing_action_deactivation_plugin', 'urbango_listing_remove_administrator_role_caps' );
}
