(function ($) {
	"use strict";
	
	var listingMaps = {};
	edgtf.modules.listingMaps = listingMaps;
	listingMaps.edgtfInitMultipleListingMap = edgtfInitMultipleListingMap;
	listingMaps.edgtfInitMobileMap = edgtfInitMobileMap;
	listingMaps.edgtfReinitMultipleGoogleMaps = edgtfReinitMultipleGoogleMaps;
	listingMaps.edgtfGoogleMaps = {};
	
	$(window).on('load', edgtfOnWindowLoad);
	
	function edgtfOnWindowLoad() {
		edgtfInitMobileMap();
		edgtfBindListTitlesAndMap();
	}

	$( document ).on(
		'edgtfGoogleMapsCallbackEvent',
		function () {
			edgtfInitMultipleListingMap();
		}
	);
	
	function edgtfInitMultipleListingMap() {
		var mapHolder = $('#edgtf-listing-multiple-map-holder');
		
		if (mapHolder.length) {
			edgtf.modules.listingMaps.edgtfGoogleMaps.getDirectoryItemsAddresses({
				mapHolder: 'edgtf-listing-multiple-map-holder',
				hasFilter: true
			});
		}
	}
	
	function edgtfInitMobileMap() {
		var mapOpener = $('.edgtf-listing-view-larger-map a'),
			mapOpenerIcon = mapOpener.children('i'),
			mapHolder = $('.edgtf-map-holder');
		
		if (mapOpener.length) {
			mapOpener.on('click', function (e) {
				e.preventDefault();
				
				if (mapHolder.hasClass('edgtf-fullscreen-map')) {
					mapHolder.removeClass('edgtf-fullscreen-map');
					mapOpenerIcon.removeClass('icon-basic-magnifier-minus');
					mapOpenerIcon.addClass('icon-basic-magnifier-plus');
				} else {
					mapHolder.addClass('edgtf-fullscreen-map');
					mapOpenerIcon.removeClass('icon-basic-magnifier-plus');
					mapOpenerIcon.addClass('icon-basic-magnifier-minus');
				}
				
				edgtf.modules.listingMaps.edgtfGoogleMaps.getDirectoryItemsAddresses();
			});
		}
	}
	
	function edgtfReinitMultipleGoogleMaps(addresses, action) {
		if (action === 'append') {
			var mapObjs = edgtfMultipleMapVars.multiple.addresses.concat(addresses);
			edgtfMultipleMapVars.multiple.addresses = mapObjs;
			
			edgtf.modules.listingMaps.edgtfGoogleMaps.getDirectoryItemsAddresses({
				addresses: mapObjs
			});
		} else if (action === 'replace') {
			edgtfMultipleMapVars.multiple.addresses = addresses;
			edgtf.modules.listingMaps.edgtfGoogleMaps.getDirectoryItemsAddresses({
				addresses: addresses
			});
		}
		
		edgtfBindListTitlesAndMap();
	}
	
	function edgtfBindListTitlesAndMap() {
		var itemsList = $('.edgtf-map-list-holder');
		
		if (itemsList.length) {
			itemsList.each(function () {
				var thisItemsList = $(this),
					listItems = thisItemsList.find('article'),
					map = thisItemsList.find('.edgtf-map-list-map-part');
				
				if (map.length) {
					listItems.each(function () {
						//Init hover
						var listItem = $(this);
						
						if (!listItem.hasClass('edgtf-init')) {
							listItem.mouseenter(function () {
								var itemId = listItem.data('id'),
									inactiveMarkersHolder = $('.edgtf-map-marker-holder:not(.edgtf-map-active)'),
									clusterMarkersHolder = $('.edgtf-cluster-marker');
								
								if (inactiveMarkersHolder.length) {
									inactiveMarkersHolder.removeClass('edgtf-active');
									$('#' + itemId + '.edgtf-map-marker-holder').addClass('edgtf-active');
								}
								
								if (clusterMarkersHolder.length) {
									clusterMarkersHolder.each(function () {
										var thisClusterMarker = $(this),
											clusterMarkersItemIds = thisClusterMarker.data('item-ids');
									
										if (clusterMarkersItemIds !== undefined && clusterMarkersItemIds.includes(itemId.toString())) {
											thisClusterMarker.addClass('edgtf-active');
										}
									});
								}
							}).mouseleave(function () {
								var markersHolder = $('.edgtf-map-marker-holder'),
									clusterMarkersHolder = $('.edgtf-cluster-marker');
								
								if (markersHolder.length) {
									markersHolder.each(function () {
										var thisMapHolder = $(this);
										
										if (!thisMapHolder.hasClass('edgtf-map-active')) {
											thisMapHolder.removeClass('edgtf-active');
										}
									});
								}
								
								if (clusterMarkersHolder.length) {
									clusterMarkersHolder.removeClass('edgtf-active');
								}
							});
							
							listItem.addClass('edgtf-init');
						}
					});
				}
			});
		}
	}
	
	listingMaps.edgtfGoogleMaps = {
		//Object variables
		mapHolder: {},
		map: {},
		markers: {},
		radius: {},
		circle: {},
		
		/**
		 * Returns map with single address
		 *
		 * @param options
		 */
		getDirectoryItemAddress: function (options) {
			/**
			 * use edgtfMapsVars to get variables for address, latitude, longitude by default
			 */
			var defaults = {
				location: edgtfSingleMapVars.single['currentListing'].location,
				zoom: 16,
				mapHolder: '',
				draggable: edgtfMapsVars.global.draggable,
				mapTypeControl: edgtfMapsVars.global.mapTypeControl,
				scrollwheel: edgtfMapsVars.global.scrollable,
				streetViewControl: edgtfMapsVars.global.streetViewControl,
				zoomControl: edgtfMapsVars.global.zoomControl,
				title: edgtfSingleMapVars.single['currentListing'].title,
				itemId: edgtfSingleMapVars.single['currentListing'].itemId,
				content: '',
				styles: edgtfMapsVars.global.mapStyle,
				termIcon: edgtfSingleMapVars.single['currentListing'].termIcon,
				featuredImage: edgtfSingleMapVars.single['currentListing'].featuredImage,
				itemUrl: edgtfSingleMapVars.single['currentListing'].itemUrl
			};
			var settings = $.extend({}, defaults, options);
			
			//Save variables for later usage
			this.mapHolder = settings.mapHolder;
			
			//Get map holder
			var mapHolder = document.getElementById(settings.mapHolder);
			
			//Initialize map
			var map = new google.maps.Map(mapHolder, {
				zoom: settings.zoom,
				draggable: settings.draggable,
				mapTypeControl: settings.mapTypeControl,
				scrollwheel: settings.scrollwheel,
				streetViewControl: settings.streetViewControl,
				zoomControl: settings.zoomControl
			});
			
			//Set map style
			map.setOptions({
				styles: settings.styles
			});
			
			//Try to locate by latitude and longitude
			if (typeof settings.location !== 'undefined' && settings.location !== null) {
				var latLong = {
					lat: parseFloat(settings.location.latitude),
					lng: parseFloat(settings.location.longitude)
				};
				//Set map center to location
				map.setCenter(latLong);
				//Add marker to map
				
				var templateData = {
					title: settings.title,
					itemId: settings.itemId,
					address: settings.location.address,
					featuredImage: settings.featuredImage,
					itemUrl: settings.itemUrl
				};
				
				var customMarker = new window.edgtfCustomMarker({
					map: map,
					position: latLong,
					templateData: templateData,
					termIcon: settings.termIcon
				});
				
				this.initMarkerInfo();
			}
		},
		
		/**
		 * Returns map with multiple addresses
		 *
		 * @param options
		 */
		getDirectoryItemsAddresses: function (options) {
			var defaults = {
				geolocation: false,
				mapHolder: 'edgtf-listing-multiple-map-holder',
				addresses: edgtfMultipleMapVars.multiple.addresses,
				draggable: edgtfMapsVars.global.draggable,
				mapTypeControl: edgtfMapsVars.global.mapTypeControl,
				scrollwheel: edgtfMapsVars.global.scrollable,
				streetViewControl: edgtfMapsVars.global.streetViewControl,
				zoomControl: edgtfMapsVars.global.zoomControl,
				zoom: 16,
				styles: edgtfMapsVars.global.mapStyle,
				radius: 50, //radius for marker visibility, in km
				hasFilter: false
			};
			var settings = $.extend({}, defaults, options);
			
			//Get map holder
			var mapHolder = document.getElementById(settings.mapHolder);
			
			//Initialize map
			var map = new google.maps.Map(mapHolder, {
				zoom: settings.zoom,
				draggable: settings.draggable,
				mapTypeControl: settings.mapTypeControl,
				scrollwheel: settings.scrollwheel,
				streetViewControl: settings.streetViewControl,
				zoomControl: settings.zoomControl
			});
			
			//Save variables for later usage
			this.mapHolder = settings.mapHolder;
			this.map = map;
			this.radius = settings.radius;
			
			//Set map style
			map.setOptions({
				styles: settings.styles
			});
			
			//If geolocation enabled set map center to user location
			if (navigator.geolocation && settings.geolocation) {
				this.centerOnCurrentLocation();
			}
			
			//Filter addresses, remove items without latitude and longitude
			var addresses = [];
			
			if (typeof settings.addresses !== 'undefined') {
				var addressesLength = settings.addresses.length;
				
				if (settings.addresses.length !== null) {
					for (var i = 0; i < addressesLength; i++) {
						var location = settings.addresses[i].location;
						
						if (typeof location !== 'undefined' && location !== null) {
							
							if (location.latitude !== '' && location.longitude !== '') {
								addresses.push(settings.addresses[i]);
							}
						}
					}
				}
			}
			
			//Center map and set borders of map
			this.setMapBounds(addresses);
			
			//Add markers to the map
			this.addMultipleMarkers(addresses);
		},
		
		/**
		 * Add multiple markers to map
		 */
		addMultipleMarkers: function (markersData) {
			var map = this.map;
			var markers = [];
			
			//Loop through markers
			var len = markersData.length;
			
			for (var i = 0; i < len; i++) {
				var latLng = {
					lat: parseFloat(markersData[i].location.latitude),
					lng: parseFloat(markersData[i].location.longitude)
				};
				
				//Custom html markers
				//Insert marker data into info window template
				var templateData = {
					title: markersData[i].title,
					itemId: markersData[i].itemId,
					address: markersData[i].location.address,
					featuredImage: markersData[i].featuredImage,
					itemUrl: markersData[i].itemUrl,
					latLng: latLng
				};
				
				var customMarker = new window.edgtfCustomMarker({
					position: latLng,
					map: map,
					templateData: templateData,
					termIcon: markersData[i].termIcon
				});
				
				markers.push(customMarker);
			}
			
			this.markers = markers;
			
			//Init map clusters ( Grouping map markers at small zoom values )
			this.initMapClusters();
			
			//Init marker info
			this.initMarkerInfo();
		},
		
		/**
		 * Set map bounds for Map with multiple markers
		 *
		 * @param addressesArray
		 */
		setMapBounds: function (addressesArray) {
			var bounds = new google.maps.LatLngBounds();
			
			for (var i = 0; i < addressesArray.length; i++) {
				bounds.extend(new google.maps.LatLng(parseFloat(addressesArray[i].location.latitude), parseFloat(addressesArray[i].location.longitude)));
			}
			
			this.map.fitBounds(bounds);
		},
		
		/**
		 * Init map clusters for grouping markers on small zoom values
		 */
		initMapClusters: function () {
			
			//Activate clustering on multiple markers
			var markerClusteringOptions = {
				minimumClusterSize: 2,
				maxZoom: 12,
				styles: [{
					width: 50,
					height: 60,
					url: '',
					textSize: 12
				}]
			};
			
			var markerClusterer = new MarkerClusterer(this.map, this.markers, markerClusteringOptions);
		},
		
		initMarkerInfo: function () {
			var map = this.map;
			
			$(document).off('click', '.edgtf-map-marker').on('click', '.edgtf-map-marker', function (e) {
				var self = $(this),
					markerHolders = $('.edgtf-map-marker-holder'),
					infoWindows = $('.edgtf-info-window'),
					markerHolder = self.parent('.edgtf-map-marker-holder'),
					markerlatlngData = markerHolder.data('latlng'),
					infoWindow = self.siblings('.edgtf-info-window');
				
				if (markerHolder.hasClass('edgtf-active edgtf-map-active')) {
					markerHolder.removeClass('edgtf-active edgtf-map-active');
					infoWindow.fadeOut(0);
				} else {
					markerHolders.removeClass('edgtf-active edgtf-map-active');
					infoWindows.fadeOut(0);
					markerHolder.addClass('edgtf-active edgtf-map-active');
					infoWindow.fadeIn(300);
					
					if (markerlatlngData.length && markerlatlngData !== undefined) {
						var latlngStr = markerlatlngData.replace('(', '').replace(')', '').split(',', 2);
						var lat = parseFloat(latlngStr[0]);
						var lng = parseFloat(latlngStr[1]);
						
						map.setCenter(new google.maps.LatLng(lat, lng));
					}
				}
			});
		},
		
		/**
		 * If geolocation enabled center map on users current position
		 */
		centerOnCurrentLocation: function (setInputAddressValue, placesInput, geoLocationLinkIcon, listingListHolder) {
			var map = this.map;
			
			// Try HTML5 geolocation.
			if (navigator.geolocation) {
				if (setInputAddressValue) {
					geoLocationLinkIcon.addClass('fa-spinner fa-spin');
				}
				
				navigator.geolocation.getCurrentPosition(
					function (position) {
						var lat = position.coords.latitude,
							lng = position.coords.longitude,
							latlng = {
								lat: lat,
								lng: lng
							};
						
						if (setInputAddressValue) {
							var geocoder = new google.maps.Geocoder(),
								cityName = '',
								cityWithCountryName = '';
							
							geocoder.geocode({'latLng': new google.maps.LatLng(lat, lng)}, function (results, status) {
								if (status === google.maps.GeocoderStatus.OK && typeof results === 'object') {
									var resultsObject = results;
									
									for (var $i = 0; $i <= resultsObject.length; $i++) {
										var result = resultsObject[$i];
										
										if (typeof result === 'object' && result.types[0] === 'locality') {
											var currentAddress = result.address_components;
											
											cityName = currentAddress[0].long_name;
											
											for (var $j = 0; $j <= currentAddress.length; $j++) {
												if (typeof currentAddress[$j] === 'object' && currentAddress[$j].types[0] === 'country') {
													cityWithCountryName = cityName + ',' + currentAddress[$j].long_name;
												}
											}
										}
									}
							
									if (typeof cityName === 'string') {
										geoLocationLinkIcon.removeClass('fa-spinner fa-spin');
										
										if (typeof cityWithCountryName === 'string') {
											placesInput.val(cityWithCountryName);
										} else {
											placesInput.val(cityName);
										}
										
										// ReInit listing list and map
										if (listingListHolder) {
											var locationObject = [];
											
											locationObject.push(cityName);
											locationObject.push(latlng);
											locationObject.push(true);
											
											edgtf.modules.listingList.edgtfInitGeoLocationRangeSlider().showRangeSlider(latlng, true);
											edgtf.modules.listingList.edgtfInitListingListPagination().getMainPagFunction(listingListHolder, 1, true, locationObject);
										}
									}
								}
							});
						} else {
							map.setCenter(latlng);
						}
					}
				);
			}
		},
		
		/**
		 * Center map on forward location position
		 */
		centerOnForwardLocation: function (forwardLocation, markerEnabled, addressName) {
			var map = this.map;
			
			if (typeof forwardLocation === 'object') {
				
				if (markerEnabled) {
					var customMarker = new window.edgtfCustomMarker({
						map: map,
						position: forwardLocation,
						templateData: {
							title: 'Your location is here',
							itemId: 'edgtf-geo-location-marker',
							address: addressName,
							featuredImage: '',
							itemUrl: ''
						}
					});
					
					listingMaps.edgtfGoogleMaps.initMarkerInfo();
				}
				
				map.setZoom(12);
				map.setCenter(forwardLocation);
			}
		},
		
		/**
		 * Center map on forward address name location
		 */
		centerOnForwardAddressLocation: function (addressName) {
			
			if (typeof addressName === 'string' && typeof google === 'object') {
				var geocoder = new google.maps.Geocoder();
				
				geocoder.geocode({'address': addressName}, function (results, status) {
					if (status === google.maps.GeocoderStatus.OK && typeof results[0] === 'object') {
						listingMaps.edgtfGoogleMaps.centerOnForwardLocation(results[0].geometry.location);
					}
				});
			}
		},
		
		/**
		 * Set radius for current geo location location
		 */
		setGeoLocationRadius: function (forwardLocation, radius, isActive) {
			var map = this.map,
				circle = this.circle,
				markers = this.markers;
			
			if (typeof forwardLocation === 'object' && typeof google === 'object') {
				
				if (isActive) {
					circle.setMap(null);
				}
				
				this.circle = new google.maps.Circle({
					map: map,
					center: forwardLocation,
					radius: parseInt(radius, 10) * 1000, // 1000 change meters to kilometers
					strokeWeight: 0,
					fillColor: '#fc475f',
					fillOpacity: 0.15
				});
				
				var currentCircle = this.circle;
				
				var itemsInArea = [];
				$.each(markers, function(i,marker) {
					if (currentCircle.getBounds().contains(marker.latlng)) {
						itemsInArea.push(marker.templateData.itemId);
					}
				});
				
				edgtf.modules.listingList.edgtfInitGeoLocationRangeSlider().disableItemsOutOfRange(itemsInArea);
			}
		},
		
		/**
		 * Create autocomplete places for forward input field
		 */
		createAutocompletePlaces: function (placeInputID, listingListHolder) {
			
			if (typeof google === 'object' && typeof google.maps.places === 'object') {
				var autocompleteConfig = {
					types: ['(cities)']
				};
				
				var autocomplete = new google.maps.places.Autocomplete(placeInputID, autocompleteConfig);
				
				autocomplete.addListener('place_changed', function () {
					// Enable reset icon in field
					$(placeInputID).next().show();
					
					if (listingListHolder) {
						var place = autocomplete.getPlace();
						
						if (!place.geometry) {
							window.alert("No details available for input: '" + place.name + "'");
							return;
						}
						
						var locationObject = [];
						
						locationObject.push(place.address_components[0].short_name);
						locationObject.push(place.geometry.location);
						locationObject.push(false);
						
						// ReInit listing list and map
						edgtf.modules.listingList.edgtfInitGeoLocationRangeSlider().reset();
						edgtf.modules.listingList.edgtfInitListingListPagination().getMainPagFunction(listingListHolder, 1, true, locationObject);
					}
				});
			}
		}
	};
	
})(jQuery);