<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_map_options_map' ) ) {
	function urbango_listing_map_options_map( $panel ) {
		
		$panel_maps = urbango_edge_add_admin_panel(
			array(
				'name'  => 'panel_maps',
				'title' => esc_html__( 'Maps', 'urbango-listing' ),
				'page'  => $panel
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'        => 'listing_map_style',
				'type'        => 'textarea',
				'label'       => esc_html__( 'Maps Style', 'urbango-listing' ),
				'description' => esc_html__( 'Insert map style json', 'urbango-listing' ),
				'parent'      => $panel_maps
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_maps_scrollable',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Scrollable Maps', 'urbango-listing' ),
				'parent'        => $panel_maps
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_maps_draggable',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Draggable Maps', 'urbango-listing' ),
				'parent'        => $panel_maps
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_maps_street_view_control',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Maps Street View Controls', 'urbango-listing' ),
				'parent'        => $panel_maps
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_maps_zoom_control',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Maps Zoom Control', 'urbango-listing' ),
				'parent'        => $panel_maps
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_maps_type_control',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Maps Type Control', 'urbango-listing' ),
				'parent'        => $panel_maps
			)
		);
	}
	
	add_action( 'urbango_listing_action_additional_listing_options_map', 'urbango_listing_map_options_map' );
}
