(function ($) {
	'use strict';
	
	var enquiry = {};
	edgtf.modules.enquiry = enquiry;
	
	enquiry.edgtfOnDocumentReady = edgtfOnDocumentReady;
	
	$(document).ready(edgtfOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		edgtfInitEnquiryForm();
	}
	
	/**
	 * Initializes enquiry form
	 */
	function edgtfInitEnquiryForm() {
		var singleHolder = $('.edgtf-listing-single-holder'),
			enquiryHolder = $('.edgtf-enquiry-holder');
		
		if (enquiryHolder.length) {
			var openerButton = singleHolder.find('.edgtf-enquiry-opener'),
				enquiryForm = enquiryHolder.find('.edgtf-enquiry-form'),
				enquiryFormCloseButton = enquiryHolder.find('.edgtf-enquiry-close'),
				responseMessage = enquiryHolder.find('.edgtf-enquiry-response');
			
			openerButton.on('click', function () {
				enquiryHolder.fadeIn(300).addClass('edgtf-opened');
			});
			
			enquiryFormCloseButton.on('click', function (e) {
				e.preventDefault();
				
				enquiryHolder.fadeOut(300).removeClass('edgtf-opened');
			});
			
			// Close form on esc key
			$(window).on('keyup', function (e) {
				if (enquiryHolder.hasClass('edgtf-opened') && e.keyCode === 27) {
					enquiryHolder.fadeOut(300).removeClass('edgtf-opened');
				}
			});
			
			enquiryForm.on('submit', function (e) {
				e.preventDefault();
				
				responseMessage.empty().html('<span class="fa fa-spinner fa-spin" aria-hidden="true"></span>');
				
				var enquiryData = {
					name: enquiryForm.find('#edgtf-enquiry-name').val(),
					email: enquiryForm.find('#edgtf-enquiry-email').val(),
					message: enquiryForm.find('#edgtf-enquiry-message').val(),
					itemID: enquiryForm.find('#edgtf-enquiry-item-id').val(),
					nonce: enquiryForm.find('#urbango_listing_nonce_listing_item_enquiry_form').val()
				};
				
				var requestData = {
					action: 'urbango_listing_send_listing_item_enquiry',
					enquiryData: enquiryData
				};
				
				$.ajax({
					type: "POST",
					url: edgtfGlobalVars.vars.edgtfAjaxUrl,
					data: requestData,
					success: function (data) {
						var response = JSON.parse(data);
						
						if (response.status === 'success') {
							responseMessage.html(response.message);
							
							setTimeout(function () {
								enquiryHolder.fadeOut(300).removeClass('edgtf-opened');
							}, 800);
						} else {
							responseMessage.html(response.message);
						}
					}
				});
			});
		}
	}
	
})(jQuery);