<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_include_shortcodes_file' ) ) {
	/**
	 * Loads all shortcodes by going through all folders that are placed directly in shortcodes folder
	 */
	function urbango_listing_include_shortcodes_file() {
		if ( urbango_listing_is_theme_installed() ) {
			do_action( 'urbango_listing_action_include_shortcodes_file' );
		}
	}
	
	add_action( 'init', 'urbango_listing_include_shortcodes_file', 6 ); // permission 6 is set to be before vc_before_init hook that has permission 9
}

if ( ! function_exists( 'urbango_listing_load_shortcodes' ) ) {
	function urbango_listing_load_shortcodes() {
		if ( urbango_listing_is_theme_installed() ) {
			include_once URBANGO_LISTING_ABS_PATH . '/lib/shortcode-loader.php';
			
			UrbanGoListing\Lib\ShortcodeLoader::getInstance()->load();
		}
	}
	
	add_action( 'init', 'urbango_listing_load_shortcodes', 7 ); // permission 7 is set to be before vc_before_init hook that has permission 9 and after urbango_listing_include_shortcodes_file hook
}

if ( ! function_exists( 'urbango_listing_add_admin_shortcodes_styles' ) ) {
	/**
	 * Function that includes shortcodes core styles for admin
	 */
	function urbango_listing_add_admin_shortcodes_styles() {
		
		//include shortcode styles for Visual Composer
		wp_enqueue_style( 'urbango-listing-vc-shortcodes', URBANGO_LISTING_ASSETS_URL_PATH . '/css/admin/vc-shortcodes.css' );
	}
	
	add_action( 'urbango_edge_action_admin_scripts_init', 'urbango_listing_add_admin_shortcodes_styles' );
}

if ( ! function_exists( 'urbango_listing_add_admin_shortcodes_custom_styles' ) ) {
	/**
	 * Function that print custom vc shortcodes style
	 */
	function urbango_listing_add_admin_shortcodes_custom_styles() {
		$style                  = apply_filters( 'urbango_listing_filter_add_vc_shortcodes_custom_style', $style = '' );
		$shortcodes_icon_styles = array();
		$shortcode_icon_size    = 32;
		$shortcode_position     = 0;
		
		$shortcodes_icon_class_array = apply_filters( 'urbango_listing_filter_add_vc_shortcodes_custom_icon_class', $shortcodes_icon_class_array = array() );
		sort( $shortcodes_icon_class_array );
		
		if ( ! empty( $shortcodes_icon_class_array ) ) {
			foreach ( $shortcodes_icon_class_array as $shortcode_icon_class ) {
				$mark = $shortcode_position != 0 ? '-' : '';
				
				$shortcodes_icon_styles[] = '.vc_element-icon.extended-custom-listing-icon' . esc_attr( $shortcode_icon_class ) . ' {
					background-position: ' . $mark . esc_attr( $shortcode_position * $shortcode_icon_size ) . 'px 0;
				}';
				
				$shortcode_position ++;
			}
		}
		
		if ( ! empty( $shortcodes_icon_styles ) ) {
			$style .= implode( ' ', $shortcodes_icon_styles );
		}
		
		if ( ! empty( $style ) ) {
			wp_add_inline_style( 'urbango-listing-vc-shortcodes', $style );
		}
	}
	
	add_action( 'urbango_edge_action_admin_scripts_init', 'urbango_listing_add_admin_shortcodes_custom_styles' );
}
