(function ($) {
	'use strict';
	
	$(document).ready(edgtfOnDocumentReady);
	$(window).on('load', edgtfOnWindowLoad);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		edgtfInitSinglePageAmenityLogic();
	}
	
	/*
	 All functions to be called on $(window).on('load',) should be in this function
	 */
	function edgtfOnWindowLoad() {
	}
	
	/**
	 * Initializes single page amenity logic
	 */
	function edgtfInitSinglePageAmenityLogic() {
		var holder = $('#edgtf_edgtf_listing_single_included_amenities_meta'),
			mainTaxonomyPanel = $('.postbox-container #listing-amenitydiv');
		
		if (holder.length && mainTaxonomyPanel.length) {
			var cbItems = holder.find('input[name="edgtf_listing_single_included_amenities_meta[]"]'),
				mainCBItems = mainTaxonomyPanel.find('input[name="tax_input[listing-amenity][]"]');
			
			if (cbItems.length && mainCBItems.length) {
				cbItems.each(function () {
					var thisCBitem = $(this),
						thisCBItemLabel = thisCBitem.parent().children('label');
					
					thisCBitem.on('click', function () {
						var clickedCBItem = $(this),
							clickedCBItemValue = clickedCBItem.val();
						
						checkboxClickLogic(clickedCBItem, clickedCBItemValue);
					});
					
					thisCBItemLabel.on('click', function () {
						var clickedCBItem = $(this).parent().children('input[type="checkbox"]'),
							clickedCBItemValue = clickedCBItem.val();
						
						checkboxClickLogic(clickedCBItem, clickedCBItemValue);
					});
				});
			}
		}
		
		function checkboxClickLogic(clickedCBItem, clickedCBItemValue) {
			if (clickedCBItemValue.length) {
				mainCBItems.each(function () {
					var thisMainCBItem = $(this),
						thisMainCBItemValue = thisMainCBItem.val();
					
					if (thisMainCBItemValue === clickedCBItemValue) {
						if (clickedCBItem.is(':checked')) {
							thisMainCBItem.prop('checked', true);
						} else {
							thisMainCBItem.prop('checked', false);
						}
					}
				});
			}
		}
	}
	
})(jQuery);