<?php

if ( ! function_exists( 'urbango_core_reviews_map' ) ) {
	function urbango_core_reviews_map() {
		
		$reviews_panel = urbango_edge_add_admin_panel(
			array(
				'title' => esc_html__( 'Reviews', 'urbango-core' ),
				'name'  => 'panel_reviews',
				'page'  => '_page_page'
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'      => $reviews_panel,
				'type'        => 'text',
				'name'        => 'reviews_section_title',
				'label'       => esc_html__( 'Reviews Section Title', 'urbango-core' ),
				'description' => esc_html__( 'Enter title that you want to show before average rating on your page', 'urbango-core' ),
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'      => $reviews_panel,
				'type'        => 'textarea',
				'name'        => 'reviews_section_subtitle',
				'label'       => esc_html__( 'Reviews Section Subtitle', 'urbango-core' ),
				'description' => esc_html__( 'Enter subtitle that you want to show before average rating on your page', 'urbango-core' ),
			)
		);
	}
	
	add_action( 'urbango_edge_action_additional_page_options_map', 'urbango_core_reviews_map', 75 ); //one after elements
}