<?php

if ( ! function_exists( 'urbango_core_map_testimonials_meta' ) ) {
	function urbango_core_map_testimonials_meta() {
		$testimonial_meta_box = urbango_edge_create_meta_box(
			array(
				'scope' => array( 'testimonials' ),
				'title' => esc_html__( 'Testimonial', 'urbango-core' ),
				'name'  => 'testimonial_meta'
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_testimonial_text',
				'type'        => 'text',
				'label'       => esc_html__( 'Text', 'urbango-core' ),
				'description' => esc_html__( 'Enter testimonial text', 'urbango-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_testimonial_author',
				'type'        => 'text',
				'label'       => esc_html__( 'Author', 'urbango-core' ),
				'description' => esc_html__( 'Enter author name', 'urbango-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_core_map_testimonials_meta', 95 );
}