<?php

namespace UrbanGoCore\CPT\Testimonials;

use UrbanGoCore\Lib;

/**
 * Class TestimonialsRegister
 * @package UrbanGoCore\CPT\Testimonials
 */
class TestimonialsRegister implements Lib\PostTypeInterface {
	private $base;
	private $taxBase;
	
	public function __construct() {
		$this->base    = 'testimonials';
		$this->taxBase = 'testimonials-category';
	}
	
	/**
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}
	
	/**
	 * Registers custom post type with WordPress
	 */
	public function register() {
		$this->registerPostType();
		$this->registerTax();
	}
	
	/**
	 * Regsiters custom post type with WordPress
	 */
	private function registerPostType() {
		$menuPosition = 36;
		$menuIcon     = 'dashicons-format-quote';
		
		register_post_type( 'testimonials',
			array(
				'labels'        => array(
					'menu_name'     => esc_html__( 'UrbanGo Testimonials', 'urbango-core' ),
					'name'          => esc_html__( 'Testimonials', 'urbango-core' ),
					'singular_name' => esc_html__( 'Testimonial', 'urbango-core' ),
					'add_item'      => esc_html__( 'New Testimonial', 'urbango-core' ),
					'add_new_item'  => esc_html__( 'Add New Testimonial', 'urbango-core' ),
					'edit_item'     => esc_html__( 'Edit Testimonial', 'urbango-core' )
				),
				'public'        => false,
				'show_in_menu'  => true,
				'rewrite'       => array( 'slug' => 'testimonials' ),
				'menu_position' => $menuPosition,
				'show_ui'       => true,
				'has_archive'   => false,
				'hierarchical'  => false,
				'supports'      => array( 'title', 'thumbnail' ),
				'menu_icon'     => $menuIcon
			)
		);
	}
	
	/**
	 * Registers custom taxonomy with WordPress
	 */
	private function registerTax() {
		$labels = array(
			'name'              => esc_html__( 'Testimonials Categories', 'urbango-core' ),
			'singular_name'     => esc_html__( 'Testimonial Category', 'urbango-core' ),
			'search_items'      => esc_html__( 'Search Testimonials Categories', 'urbango-core' ),
			'all_items'         => esc_html__( 'All Testimonials Categories', 'urbango-core' ),
			'parent_item'       => esc_html__( 'Parent Testimonial Category', 'urbango-core' ),
			'parent_item_colon' => esc_html__( 'Parent Testimonial Category:', 'urbango-core' ),
			'edit_item'         => esc_html__( 'Edit Testimonials Category', 'urbango-core' ),
			'update_item'       => esc_html__( 'Update Testimonials Category', 'urbango-core' ),
			'add_new_item'      => esc_html__( 'Add New Testimonials Category', 'urbango-core' ),
			'new_item_name'     => esc_html__( 'New Testimonials Category Name', 'urbango-core' ),
			'menu_name'         => esc_html__( 'Testimonials Categories', 'urbango-core' )
		);
		
		register_taxonomy( $this->taxBase, array( $this->base ), array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'query_var'         => true,
			'show_admin_column' => true,
			'rewrite'           => array( 'slug' => 'testimonials-category' )
		) );
	}
}