<?php
$current_user        = wp_get_current_user();
$name                = $current_user->display_name;
$current_user_id     = $current_user->ID;
$membership_page_url = urbango_membership_get_dashboard_page_url();
?>
<div class="edgtf-logged-in-user">
    <div class="edgtf-logged-in-user-inner">
        <span class="edgtf-logged-in-user-avatar">
            <?php if ( urbango_membership_theme_installed() ) {
	            $profile_image = get_user_meta( $current_user_id, 'social_profile_image', true );
	            if ( $profile_image == '' ) {
		            $profile_image = get_avatar( $current_user_id, 28 );
	            } else {
		            $profile_image = '<img src="' . esc_url( $profile_image ) . '" />';
	            }
	            echo urbango_membership_kses_img( $profile_image );
            } ?>
        </span>
        <span class="edgtf-logged-in-user-name"><?php echo esc_html( $name ); ?></span>
		<?php echo urbango_edge_icon_collections()->renderIcon( 'arrow_carrot-down', 'font_elegant', array( 'icon_attributes' => array( 'class' => 'edgtf-logged-in-arrow' ) ) ); ?>
    </div>
</div>
<ul class="edgtf-login-dropdown">
	<?php
	$nav_items = urbango_membership_get_dashboard_navigation_items();
	foreach ( $nav_items as $nav_item ) { ?>
        <li>
            <a href="<?php echo esc_url( $nav_item['url'] ); ?>">
				<?php if ( isset( $nav_item['font_icon'] ) && ! empty( $nav_item['font_icon'] ) ) {
					echo urbango_edge_icon_collections()->renderIcon( esc_attr( $nav_item['font_icon'][0] ), esc_attr( $nav_item['font_icon'][1] ), array( 'icon_attributes' => array( 'class' => 'edgtf-icon-item' ) ) );
				} ?>
                <span class="edgtf-text-item"><?php echo wp_kses_post( $nav_item['text'] ); ?></span>
            </a>
        </li>
	<?php } ?>
    <li>
        <a href="<?php echo wp_logout_url( esc_url( home_url( '/' ) ) ); ?>">
			<?php echo urbango_edge_icon_collections()->renderIcon( 'far fa-share-square', 'font_awesome', array( 'icon_attributes' => array( 'class' => 'edgtf-icon-item' ) ) ); ?>
            <span class="edgtf-text-item"><?php esc_html_e( 'Log Out', 'urbango-membership' ); ?></span>
        </a>
    </li>
</ul>