<div class="edgtf-social-register-holder">
	<form method="post" class="edgtf-register-form">
		<fieldset>
			<div>
				<input type="text" name="user_register_name" id="user_register_name" placeholder="<?php esc_attr_e( 'User Name', 'urbango-membership' ) ?>" value="" required pattern=".{3,}" title="<?php esc_attr_e( 'Three or more characters', 'urbango-membership' ); ?>"/>
			</div>
			<div>
				<input type="email" name="user_register_email" id="user_register_email" placeholder="<?php esc_attr_e( 'Email', 'urbango-membership' ) ?>" value="" required />
			</div>
            <div>
                <input type="password" name="user_register_password" id="user_register_password" placeholder="<?php esc_attr_e('Password','urbango-membership') ?>" value="" required />
            </div>
            <div>
                <input type="password" name="user_register_confirm_password" id="user_register_confirm_password" placeholder="<?php esc_attr_e('Repeat Password','urbango-membership') ?>" value="" required />
            </div>
			<label class="qodef-register-privacy-policy">
				<?php
				$privacy_policy_text      = urbango_membership_theme_installed() ? urbango_edge_options()->getOptionValue( 'edgtf_membership_privacy_policy_text' ) : '';
				$privacy_policy_link      = urbango_membership_theme_installed() ? urbango_edge_options()->getOptionValue( 'edgtf_membership_privacy_policy_link' ) : '';
				$privacy_policy_link_text = urbango_membership_theme_installed() ? urbango_edge_options()->getOptionValue( 'edgtf_membership_privacy_policy_link_text' ) : '';

				$privacy_policy_text      = ! empty( $privacy_policy_text ) ? ( esc_html( $privacy_policy_text ) . ' %s.' ) : esc_html__( 'Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our %s.', 'urbango-membership' );
				$privacy_policy_link      = ! empty( $privacy_policy_link ) ? esc_url( get_permalink( $privacy_policy_link ) ) : esc_url( home_url( '/?page_id=3' ) ); // page id 3 is default terms and condition WordPage page
				$privacy_policy_link_text = ! empty( $privacy_policy_link_text ) ? esc_html( $privacy_policy_link_text ) : esc_html__( 'privacy policy', 'urbango-membership' );

				echo sprintf(
					$privacy_policy_text,
					'<a itemprop="url" class="qodef-register-privacy-policy-link" href="' . $privacy_policy_link . '" target="_blank">' . $privacy_policy_link_text . '</a>'
				);
				?>
			</label>
			<?php do_action( 'urbango_membership_additional_registration_field' ); ?>
			<div class="edgtf-wp-section-button edgtf-register-button-holder">
				<?php if ( urbango_membership_theme_installed() ) {
					echo urbango_edge_get_button_html( array(
						'html_type' => 'button',
						'text'      => esc_html__( 'Register', 'urbango-membership' ),
						'type'      => 'solid'
					) );
				} else {
					echo '<button type="submit">' . esc_html__( 'Register', 'urbango-membership' ) . '</button>';
				}
				wp_nonce_field( 'edgtf-ajax-register-nonce', 'edgtf-register-security' ); ?>
			</div>
		</fieldset>
	</form>
	<?php if ( ! is_page_template( 'user-dashboard.php' ) ) { ?>
		<p class="edgtf-wp-section-notice">
			<span><?php esc_html_e( 'Have an account?', 'urbango-membership' ); ?></span>
			<a class="edgtf-wp-login-button" href="#"><?php esc_html_e( 'Log in', 'urbango-membership' ); ?></a>
		</p>
	<?php } ?>
	<?php do_action( 'urbango_membership_action_login_ajax_response' ); ?>
</div>