<?php
get_header();
if ( urbango_membership_theme_installed() ) {
	urbango_edge_get_title();
} else { ?>
	<div class="edgtf-membership-title">
		<?php the_title( '<h1>', '</h1>' ); ?>
	</div>
<?php }
do_action('urbango_edge_action_before_main_content');
?>
	<div class="edgtf-container">
		<?php do_action( 'urbango_edge_after_container_open' ); ?>
		<div class="edgtf-container-inner clearfix">
            <div class="edgtf-membership-main-wrapper clearfix">
                <?php if ( is_user_logged_in() ) { ?>
                    <div class="edgtf-membership-dashboard-nav-holder clearfix">
	                    <a class="edgtf-membership-dashboard-nav-opener" href="#">
		                    <?php echo urbango_membership_dashboard_menu_svg_icons( 'dashboard-menu' ); ?>
		                    <span class="edgtf-membership-dashboard-nav-opener-label"><?php esc_html_e( 'Dashboard Menu', 'urbango-membership' ); ?></span>
	                    </a>
                        <?php
                        //Include dashboard navigation
                        echo urbango_membership_get_dashboard_template_part( 'navigation' );
                        ?>
                    </div>
                    <div class="edgtf-membership-dashboard-content-holder">
                        <?php echo urbango_membership_get_dashboard_pages(); ?>
                    </div>
                <?php } else { ?>
                    <div class="edgtf-login-register-content edgtf-user-not-logged-in">
                        <ul>
                            <li>
                                <a href="#edgtf-login-content"><?php esc_html_e( 'Login', 'urbango-membership' ); ?></a>
                            </li>
                            <li>
                                <a href="#edgtf-register-content"><?php esc_html_e( 'Register', 'urbango-membership' ); ?></a>
                            </li>
                            <li>
                                <a href="#edgtf-reset-pass-content"><?php esc_html_e( 'Reset Password', 'urbango-membership' ); ?></a>
                            </li>
                        </ul>
                        <div class="edgtf-login-content-inner" id="edgtf-login-content">
                            <div class="edgtf-wp-login-holder"><?php echo urbango_membership_execute_shortcode( 'edgtf_user_login', array() ); ?></div>
                        </div>
                        <div class="edgtf-register-content-inner" id="edgtf-register-content">
                            <div class="edgtf-wp-register-holder"><?php echo urbango_membership_execute_shortcode( 'edgtf_user_register', array() ) ?></div>
                        </div>
                        <div class="edgtf-reset-pass-content-inner" id="edgtf-reset-pass-content">
                            <div class="edgtf-wp-reset-pass-holder"><?php echo urbango_membership_execute_shortcode( 'edgtf_user_reset_password', array() ) ?></div>
                        </div>
                    </div>
                <?php } ?>
            </div>
		</div>
		<?php do_action( 'urbango_edge_before_container_close' ); ?>
	</div>
<?php get_footer(); ?>