<ul class="edgtf-membership-dashboard-nav clearfix">
	<?php
	$nav_items   = urbango_membership_get_dashboard_navigation_items();
	$user_action = isset( $_GET['user-action'] ) ? $_GET['user-action'] : 'profile';
	foreach ( $nav_items as $nav_item ) {
		$item_class = 'edgtf-md-nav-' . $nav_item['icon'];
		if ( $user_action == $nav_item['user_action'] ) {
			$item_class .= ' edgtf-active-dash';
		}
		?>
        <li class="<?php echo esc_attr( $item_class ); ?>">
            <a href="<?php echo esc_url( $nav_item['url'] ); ?>">
				<?php if ( isset( $nav_item['icon'] ) ) { ?>
                    <span class="edgtf-dash-icon">
                        <?php echo urbango_membership_dashboard_menu_svg_icons( $nav_item['icon'] ); ?>
					</span>
				<?php } ?>
                <span class="edgtf-dash-label">
				    <?php echo wp_kses_post( $nav_item['text'] ); ?>
                </span>
            </a>
        </li>
	<?php } ?>
    <li class="edgtf-md-nav-log-out">
        <a href="<?php echo wp_logout_url( esc_url( home_url( '/' ) ) ); ?>">
             <span class="edgtf-dash-icon">
                <?php echo urbango_membership_dashboard_menu_svg_icons( 'log-out' ); ?>
            </span>
			<?php esc_html_e( 'Log out', 'urbango-membership' ); ?>
        </a>
    </li>
</ul>