<?php 

if ( !function_exists('urbango_membership_dashboard_edit_profile_fields') ) {
	function urbango_membership_dashboard_edit_profile_fields($params){

		extract($params);

		$edit_profile = urbango_edge_add_dashboard_fields(array(
			'name' => 'edit_profile',
		));

		$edit_profile_form = urbango_edge_add_dashboard_form(array(
			'name' => 'edit_profile_form',
			'form_id'   => 'edgtf-membership-update-profile-form',
			'form_action' => 'urbango_membership_update_user_profile',
			'parent' => $edit_profile,
			'button_label' => esc_html__('UPDATE PROFILE','urbango-membership'),
			'button_args' => array(
				'data-updating-text' => esc_html__('UPDATING PROFILE', 'urbango-membership'),
				'data-updated-text' => esc_html__('PROFILE UPDATED', 'urbango-membership'),
			)
		));

		$edit_profile_name_group = urbango_edge_add_dashboard_group(array(
			'name' => 'edit_profile_name_group',
			'parent' => $edit_profile_form,
		));

		urbango_edge_add_dashboard_field(array(
			'type' => 'text',
			'name' => 'first_name',
			'label' => esc_html__('First Name','urbango-membership'),
			'parent' => $edit_profile_name_group,
			'value' => $first_name
		));
		
		urbango_edge_add_dashboard_field(array(
			'type' => 'text',
			'name' => 'last_name',
			'label' => esc_html__('Last Name','urbango-membership'),
			'parent' => $edit_profile_name_group,
			'value' => $last_name
		));

		urbango_edge_add_dashboard_field(array(
			'type' => 'text',
			'name' => 'email',
			'label' => esc_html__('Email','urbango-membership'),
			'parent' => $edit_profile_form,
			'value' => $email,
			'args' => array(
				'input_type' => 'email'
			)
		));

		urbango_edge_add_dashboard_field(array(
			'type' => 'text',
			'name' => 'url',
			'label' => esc_html__('Website','urbango-membership'),
			'parent' => $edit_profile_form,
			'value' => $website
		));

		urbango_edge_add_dashboard_field(array(
			'type' => 'text',
			'name' => 'description',
			'label' => esc_html__('Description','urbango-membership'),
			'parent' => $edit_profile_form,
			'value' => $description
		));

		urbango_edge_add_dashboard_field(array(
			'type' => 'text',
			'name' => 'password',
			'label' => esc_html__('Password','urbango-membership'),
			'parent' => $edit_profile_form,
			'args' => array(
				'input_type' => 'password'
			)
		));

		urbango_edge_add_dashboard_field(array(
			'type' => 'text',
			'name' => 'password2',
			'label' => esc_html__('Repeat Password','urbango-membership'),
			'parent' => $edit_profile_form,
			'args' => array(
				'input_type' => 'password'
			)
		));

		$edit_profile->render();
	}
}
?>

<div class="edgtf-membership-dashboard-page">
	<div class="edgtf-lp-section-title">
		<h3 class="edgtf-lp-st-title"><?php esc_html_e( 'Edit Your Profile', 'urbango-membership' ); ?></h3>
		<p class="edgtf-lp-st-text"><?php esc_html_e( 'Update your account details, including your name, contact details, password, description and your profile photo.', 'urbango-membership' ); ?></p>
	</div>
	<div>
		<?php urbango_membership_dashboard_edit_profile_fields($params); ?>
		<?php do_action( 'urbango_membership_action_login_ajax_response' ); ?>
	</div>
</div>