// Load the SDK asynchronously
(function (d, s, id) {
	var js, fjs = d.getElementsByTagName(s)[0];
	if (d.getElementById(id)) {
		return;
	}
	js = d.createElement(s);
	js.id = id;
	js.src = "//connect.facebook.net/en_US/sdk.js";
	fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));
if (typeof edgtfSocialLoginVars !== 'undefined') {
	var facebookAppId = edgtfSocialLoginVars.social.facebookAppId;
}
if (facebookAppId) {
	window.fbAsyncInit = function () {
		FB.init({
			appId: facebookAppId, //265124653818954 - test app ID
			cookie: true,  // enable cookies to allow the server to access
			xfbml: true,  // parse social plugins on this page
			version: 'v2.5' // use version 2.5
		});

		window.FB = FB;
	};
}

(function ($) {
    "use strict";

    var socialLogin = {};
    if ( typeof edgtf !== 'undefined' ) {
        edgtf.modules.socialLogin = socialLogin;
    }

    socialLogin.edgtfUserLogin = edgtfUserLogin;
    socialLogin.edgtfUserRegister = edgtfUserRegister;
    socialLogin.edgtfUserLostPassword = edgtfUserLostPassword;
    socialLogin.edgtfInitLoginWidgetModal = edgtfInitLoginWidgetModal;
    socialLogin.edgtfInitFacebookLogin = edgtfInitFacebookLogin;
    socialLogin.edgtfRenderAjaxResponseMessage = edgtfRenderAjaxResponseMessage;

    $(document).ready(edgtfOnDocumentReady);
    $(window).on('load', edgtfOnWindowLoad);

    /**
     * All functions to be called on $(document).ready() should be in this function
     */
    function edgtfOnDocumentReady() {
        edgtfInitLoginWidgetModal();
        edgtfUserLogin();
        edgtfUserRegister();
        edgtfUserLostPassword();
	    edgtfInitUserDashboardMenu();
	    edgtfInitUserDashboardTabs();
    }

    /**
     * All functions to be called on $(window).load() should be in this function
     */
    function edgtfOnWindowLoad() {
	    edgtfInitUserLoginDropDownBehavior();
        edgtfInitFacebookLogin();
        edgtfMembershipFullScreen();
    }
	
	/**
	 * Initialize login widget modal
	 */
	function edgtfInitLoginWidgetModal() {
		var userLoggedInOpener = $('.edgtf-login-register-widget.edgtf-user-logged-in'),
			modalOpener = $('.edgtf-login-opener'),
			modalHolder = $('.edgtf-login-register-holder'),
			modalCLose  = $('.edgtf-login-register-close'),
			contentHolder = $('.edgtf-login-register-content'),
			loginContent = contentHolder.children('.edgtf-login-content-inner'),
			registerContent = contentHolder.children('.edgtf-register-content-inner'),
			forgotPassContent = contentHolder.children('.edgtf-forgot-pass-content-inner');
		
		$( document.body ).on( 'open_user_login_trigger', function() {
			modalHolder.fadeIn(300);
			modalHolder.addClass('opened');
			loginContent.addClass('edgtf-opened');
		});
		
		if (modalOpener.length) {
			var loginButton = contentHolder.find('.edgtf-wp-login-button'),
				registerButton = contentHolder.find('.edgtf-wp-register-button'),
				forgotButton = contentHolder.find('.edgtf-login-action-btn');
			
			contentHolder.on('click',function(e){
				e.stopPropagation();
			});
			
			loginButton.on('click', function (e) {
				e.preventDefault();
				
				forgotPassContent.removeClass('edgtf-opened');
				registerContent.removeClass('edgtf-opened');
				loginContent.addClass('edgtf-opened');
			});
			
			registerButton.on('click', function (e) {
				e.preventDefault();
				
				forgotPassContent.removeClass('edgtf-opened');
				loginContent.removeClass('edgtf-opened');
				registerContent.addClass('edgtf-opened');
			});
			
			forgotButton.on('click', function (e) {
				e.preventDefault();
				
				registerContent.removeClass('edgtf-opened');
				loginContent.removeClass('edgtf-opened');
				forgotPassContent.addClass('edgtf-opened');
			});
			
			//Init opening login modal
			modalOpener.on('click', function (e) {
				e.preventDefault();
				modalHolder.fadeIn(300);
				modalHolder.addClass('opened');
				loginContent.addClass('edgtf-opened');
				registerContent.removeClass('edgtf-opened');
				forgotPassContent.removeClass('edgtf-opened');
			});
			
			//Init closing login modal
			modalHolder.on('click', function (e) {
				if (modalHolder.hasClass('opened')) {
					modalHolder.fadeOut(300);
					modalHolder.removeClass('opened');
					loginContent.removeClass('edgtf-opened');
					registerContent.removeClass('edgtf-opened');
					forgotPassContent.removeClass('edgtf-opened');
				}
			});
			
			$( modalCLose ).on( 'click', function (e) {
				modalHolder.fadeOut(300);
				modalHolder.removeClass('opened');
				loginContent.removeClass('edgtf-opened');
				registerContent.removeClass('edgtf-opened');
				forgotPassContent.removeClass('edgtf-opened');
			});
			
			// on esc too
			$(window).on('keyup', function (e) {
				if (modalHolder.hasClass('opened') && e.keyCode === 27) {
					modalHolder.fadeOut(300);
					modalHolder.removeClass('opened');
					loginContent.removeClass('edgtf-opened');
					registerContent.removeClass('edgtf-opened');
					forgotPassContent.removeClass('edgtf-opened');
				}
			});
		}
	}
	
	/**
	 * Initialize user login dropdown behavior
	 */
	function edgtfInitUserLoginDropDownBehavior() {
		var userLoggedInOpener = $('.edgtf-login-register-widget.edgtf-user-logged-in');
		
		if (userLoggedInOpener.length) {
			var userLoggedInOpenerOffset = userLoggedInOpener.offset().left,
				loggedInDropDown = userLoggedInOpener.find('.edgtf-login-dropdown');
			
			if (edgtf.windowWidth - userLoggedInOpenerOffset < loggedInDropDown.outerWidth()) {
				loggedInDropDown.addClass('edgtf-right');
			}
		}
	}
	
	function edgtfInitUserDashboardMenu() {
		var menuHolder = $('.edgtf-membership-dashboard-nav-holder');
		
		if (edgtf.body.hasClass('page-template-user-dashboard') && menuHolder.length) {
			var menuOpener = menuHolder.children('.edgtf-membership-dashboard-nav-opener'),
				menu = menuHolder.children('.edgtf-membership-dashboard-nav');
			
			menuOpener.on('click', function (e) {
				e.preventDefault();
				
				if (menu.is(':visible')) {
					menu.removeClass('edgtf-opened').slideUp();
				} else {
					menu.addClass('edgtf-opened').slideDown();
				}
			});
		}
	}
	
	function edgtfInitUserDashboardTabs() {
		var tabsHolder = $('.edgtf-login-register-content');
		
		if (edgtf.body.hasClass('page-template-user-dashboard') && tabsHolder.length) {
			//Init tabs
			tabsHolder.tabs().css('opacity', '1');
		}
	}

    /**
     * Login user via Ajax
     */
    function edgtfUserLogin() {
        $('.edgtf-login-form').on('submit', function (e) {
            e.preventDefault();
            
            var ajaxData = {
                action: 'urbango_membership_login_user',
                security: $(this).find('#edgtf-login-security').val(),
                login_data: $(this).serialize()
            };
            
            $.ajax({
                type: 'POST',
                data: ajaxData,
                url: edgtfGlobalVars.vars.edgtfAjaxUrl,
                success: function (data) {
                    var response;
                    response = JSON.parse(data);

                    edgtfRenderAjaxResponseMessage(response);
                    if (response.status === 'success') {
                        window.location = response.redirect;
                    }
                }
            });
            
            return false;
        });
    }

    /**
     * Register New User via Ajax
     */
    function edgtfUserRegister() {
        $('.edgtf-register-form').on('submit', function (e) {
            e.preventDefault();
            
            var ajaxData = {
                action: 'urbango_membership_register_user',
                security: $(this).find('#edgtf-register-security').val(),
                register_data: $(this).serialize()
            };

            $.ajax({
                type: 'POST',
                data: ajaxData,
                url: edgtfGlobalVars.vars.edgtfAjaxUrl,
                success: function (data) {
                    var response;
                    response = JSON.parse(data);

                    edgtfRenderAjaxResponseMessage(response);
                    if (response.status === 'success') {
                        window.location = response.redirect;
                    }
                }
            });

            return false;
        });
    }

    /**
     * Reset user password
     */
    function edgtfUserLostPassword() {
        var lostPassForm = $('.edgtf-reset-pass-form');
        
        lostPassForm.on('submit', function (e) {
            e.preventDefault();
            
            var data = {
                action: 'urbango_membership_user_lost_password',
                user_login: lostPassForm.find('#user_reset_password_login').val()
            };
            
            $.ajax({
                type: 'POST',
                data: data,
                url: edgtfGlobalVars.vars.edgtfAjaxUrl,
                success: function (data) {
                    var response = JSON.parse(data);
                    edgtfRenderAjaxResponseMessage(response);
                    if (response.status === 'success') {
                        window.location = response.redirect;
                    }
                }
            });
        });
    }

    /**
     * Response notice for users
     * @param response
     */
    function edgtfRenderAjaxResponseMessage(response) {
        var responseHolder = $('.edgtf-membership-response-holder'), //response holder div
            responseTemplate = _.template($('.edgtf-membership-response-template').html()); //Locate template for info window and insert data from marker options (via underscore)

        var messageClass;
        if (response.status === 'success') {
            messageClass = 'edgtf-membership-message-succes';
        } else {
            messageClass = 'edgtf-membership-message-error';
        }

        var templateData = {
            messageClass: messageClass,
            message: response.message
        };

        var template = responseTemplate(templateData);
        responseHolder.html(template);
    }

    /**
     * Facebook Login
     */
    function edgtfInitFacebookLogin() {
        var loginForm = $('.edgtf-facebook-login-holder');
        loginForm.on('submit', function (e) {
            e.preventDefault();
            
            window.FB.login(function (response) {
                edgtfFacebookCheckStatus(response);
            }, {scope: 'email, public_profile'});
        });
    }

    /**
     * Check if user is logged into Facebook and App
     *
     * @param response
     */
    function edgtfFacebookCheckStatus(response) {
        if (response.status === 'connected') {
            // Logged into your app and Facebook.
            edgtfGetFacebookUserData(response.authResponse.accessToken);
        } else if (response.status === 'not_authorized') {
            // The person is logged into Facebook, but not your app.
            console.log('Please log into this app');
        } else {
            // The person is not logged into Facebook, so we're not sure if
            // they are logged into this app or not.
            console.log('Please log into Facebook');
        }
    }

    /**
     * Get user data from Facebook and login user
     */
    function edgtfGetFacebookUserData(accessToken) {
        console.log('Welcome! Fetching information from Facebook...');
        FB.api('/me', 'GET', {'fields': 'id, name, email, link, picture'}, function (response) {
            var nonce = $('.edgtf-facebook-login-holder [name^=edgtf_nonce_facebook_login]').val();
            response.nonce = nonce;
            response.image = response.picture.data.url;
			response.accessToken = accessToken;
            var data = {
                action: 'urbango_membership_check_facebook_user',
                response: response
            };
            $.ajax({
                type: 'POST',
                data: data,
                url: edgtfGlobalVars.vars.edgtfAjaxUrl,
                success: function (data) {
                    var response;
                    response = JSON.parse(data);

                    edgtfRenderAjaxResponseMessage(response);
                    if (response.status === 'success') {
                        window.location = response.redirect;
                    }
                }
            });
        });
    }

    function edgtfMembershipFullScreen() {
        var membership = $('.edgtf-membership-main-wrapper');
        var profileContent = $('.page-template-user-dashboard .edgtf-content');
        var footer = $('.edgtf-page-footer');
        var reduceHeight = 0;

        if(!edgtf.body.hasClass('edgtf-header-transparent') && edgtf.windowWidth > 1024) {
            reduceHeight = reduceHeight + edgtfGlobalVars.vars.edgtfMenuAreaHeight + edgtfGlobalVars.vars.edgtfLogoAreaHeight;
        }
        if(footer.length > 0) {
            reduceHeight += footer.outerHeight();
        }

        if(edgtf.windowWidth > 1024) {
            var height = edgtf.windowHeight - reduceHeight;
            profileContent.css({'min-height': height  + 'px'});
        }
    }

})(jQuery);