<?php
/*
Plugin Name: UrbanGo Checkout
Description: Plugin that adds custom post type to WooCommerce checkout
Author: Edge Themes
Version: 1.1
*/

include_once 'load.php';

if ( ! function_exists( 'urbango_checkout_load_checkout_plugin' ) ) {
	function urbango_checkout_load_checkout_plugin() {
		include_once 'payment/class-wc-product-edgtf.php';
		include_once 'payment/class-wc-edgtf-data-store-cpt.php';
		include_once 'payment/class-wc-order-item-edgtf.php';
		include_once 'payment/class-wc-order-item-edgtf-store.php';

		do_action( 'urbango_checkout_plugin_loaded' );
	}

	add_action( 'woocommerce_loaded', 'urbango_checkout_load_checkout_plugin' );
}

if ( ! function_exists( 'urbango_checkout_text_domain' ) ) {
	/**
	 * Loads plugin text domain so it can be used in translation
	 */
	function urbango_checkout_text_domain() {
		load_plugin_textdomain( 'urbango-checkout', false, URBANGO_CHECKOUT_INTEGRATION_PATH . '/languages' );
	}

	add_action( 'plugins_loaded', 'urbango_checkout_text_domain' );
}