<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

?>
<div class="edgtf-listing-profile-reported-items">
	<?php if ( ! empty( $user_reported_items ) ) { ?>
        <div class="edgtf-lp-section-title">
            <h3 class="edgtf-lp-st-title"><?php esc_html_e( 'Reported Items', 'urbango-listing' ); ?></h3>
            <p class="edgtf-lp-st-text"><?php esc_html_e( 'In case a listing gets reported, it will be displayed in this section. This is where the reported message, as well as the message from the administrator is displayed. Once the listing is edited, the admin can be notified about it.', 'urbango-listing' ); ?></p>
        </div>
        <div class="edgtf-lp-reported-items">
			<?php foreach ( $user_reported_items as $report_id => $item_id ) {
				$reported_message    = get_post_meta( $report_id, 'edgtf_listing_reported_user_reported_message_meta', true );
				$hide_report_message = get_post_meta( $report_id, 'edgtf_listing_reported_disable_user_reported_message_meta', true );
				$admin_message       = get_post_meta( $report_id, 'edgtf_listing_reported_admin_message_meta', true );
				$hide_admin_message  = get_post_meta( $report_id, 'edgtf_listing_reported_disable_admin_message_meta', true );
				?>
                <div class="edgtf-lp-reported-item">
                    <h4 class="edgtf-lp-ri-listing-name">
                        <a itemprop="url" href="<?php the_permalink( $item_id ); ?>"><?php echo get_the_title( $item_id ); ?></a>
                    </h4>
                    <div class="edgtf-lp-ri-messages">
						<?php if ( ! empty( $reported_message ) && $hide_report_message !== 'yes' ) { ?>
                            <div class="edgtf-lp-ri-user-info">
                                <h6 class="edgtf-lp-ri-user-label"><?php esc_html_e( 'Reported Message:', 'urbango-listing' ); ?></h6>
                                <p class="edgtf-lp-ri-user-message"><?php echo esc_html( $reported_message ); ?></p>
                            </div>
						<?php } ?>

						<?php if ( ! empty( $admin_message ) && $hide_admin_message !== 'yes' ) { ?>
                            <div class="edgtf-lp-ri-admin-info">
                                <h6 class="edgtf-lp-ri-admin-label"><?php esc_html_e( 'Admin Message:', 'urbango-listing' ); ?></h6>
                                <p class="edgtf-lp-ri-admin-message"><?php echo esc_html( $admin_message ); ?></p>
                            </div>
						<?php } ?>
                    </div>
                    <div class="edgtf-lp-ri-author-info">
                        <h6 class="edgtf-lp-ri-author-label"><?php esc_html_e( 'Your Message:', 'urbango-listing' ); ?></h6>
                        <textarea class="edgtf-lp-ri-author-message edgtf-resubmit-message" rows="3" placeholder="<?php esc_attr_e( 'Write resubmission message...', 'urbango-listing' ); ?>"></textarea>
                    </div>
                    <div class="edgtf-lp-ri-buttons">
						<?php if ( urbango_listing_is_core_plugin_installed() && urbango_listing_is_membership_plugin_installed() ) {
							echo urbango_edge_get_button_html( array(
								'custom_class' => 'edgtf-listing-item-edit',
								'type'         => 'outline',
								'size'         => 'small',
								'link'         => esc_url( add_query_arg( array(
									'user-action' => 'edit-listing',
									'listing_id'  => $item_id
								), urbango_membership_get_dashboard_page_url() ) ),
								'text'         => esc_html__( 'Edit Listing', 'urbango-listing' )
							) );

							echo urbango_edge_get_button_html( array(
								'custom_class' => 'edgtf-listing-item-resubmit',
								'type'         => 'outline',
								'size'         => 'small',
								'text'         => esc_html__( 'Resubmit Listing', 'urbango-listing' ),
								'custom_attrs' => array(
									'data-listing-id'   => $item_id,
									'data-confirm-text' => esc_html__( 'Are you sure you want to resubmit this listing?', 'urbango-listing' )
								)
							) );
						} ?>
                    </div>

					<?php wp_nonce_field( 'urbango_listing_validate_resubmit_reported_item', 'urbango_listing_nonce_resubmit_reported_item' ); ?>

                    <div class="edgtf-lp-ri-response"></div>
                </div>
			<?php } ?>
        </div>
        <p class="edgtf-lp-reported-description"><?php esc_html_e( 'In order to publish your listing again, edit your listing and fix the problems, after that just write your message to administrator and click to resubmission button. Administrator will review your listing and publish it again if all problems are fixed. Thanks for your patience.', 'urbango-listing' ); ?></p>
	<?php } else { ?>
        <h3 class="edgtf-lp-not-found"><?php esc_html_e( 'You don\'t have any reported items.', 'urbango-listing' ); ?> </h3>
	<?php } ?>
</div>