<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_reported_items_profile_navigation_item' ) ) {
	function urbango_listing_add_reported_items_profile_navigation_item( $navigation, $dashboard_url ) {
		$reports_count = urbango_listing_get_user_reported_items_count();
		$reports_html  = $reports_count > 0 ? '<span class="edgtf-reports-count">' . esc_attr( $reports_count ) . '</span>' : '';
		
		$navigation['reported-items'] = array(
			'url'         => esc_url( add_query_arg( array( 'user-action' => 'reported-items' ), $dashboard_url ) ),
			'text'        => sprintf( esc_html__( 'Reported %s', 'urbango-listing' ), $reports_html ),
			'user_action' => 'reported-items',
			'icon'        => 'reported-items',
			'font_icon'   => array( 'icon_error-triangle_alt', 'font_elegant' )
		);
		
		return $navigation;
	}
	
	add_filter( 'urbango_membership_dashboard_navigation_pages', 'urbango_listing_add_reported_items_profile_navigation_item', 20, 2 );
}

if ( ! function_exists( 'urbango_listing_add_reported_items_profile_navigation_pages' ) ) {
	function urbango_listing_add_reported_items_profile_navigation_pages( $page, $action ) {
		
		if ( $action == 'reported-items' ) {
			$params                        = array();
			$params['user_reported_items'] = urbango_listing_get_user_reported_items();
			$page                          = urbango_listing_get_module_template_part( 'cpt-report-profile', 'report', 'reported-items', '', $params, array(), false );
		}
		
		return $page;
	}
	
	add_filter( 'urbango_membership_dashboard_pages', 'urbango_listing_add_reported_items_profile_navigation_pages', 10, 2 );
}
